-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MTestType = {}

---@class MTestType.TestType
---@field TestType integer
local TTestType = {}
TTestType.__index = TTestType
TTestType.group = {}

local function TTestType_from_obj(obj)
    return setmetatable(obj, TTestType)
end

function TTestType.new(TestType)
    return TTestType_from_obj({TestType = TestType})
end
---@param obj MTestType.TestType
function TTestType:init_from_obj(obj)
    self.TestType = obj.TestType
end

function TTestType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTestType.group)
end

TTestType.from_obj = TTestType_from_obj

TTestType.proto_property = {'TestType'}

TTestType.default = {0}

TTestType.struct = {{name = 'TestType', is_array = false, struct = nil}}

function TTestType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TestType', self.TestType, 'uint8', false, errs, need_convert)

    TTestType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTestType.proto_property, errs, need_convert)
    return self
end

function TTestType:unpack(_)
    return self.TestType
end

MTestType.TestType = TTestType

---@class MTestType.TestFlag
---@field TestFlag integer
local TTestFlag = {}
TTestFlag.__index = TTestFlag
TTestFlag.group = {}

local function TTestFlag_from_obj(obj)
    return setmetatable(obj, TTestFlag)
end

function TTestFlag.new(TestFlag)
    return TTestFlag_from_obj({TestFlag = TestFlag})
end
---@param obj MTestType.TestFlag
function TTestFlag:init_from_obj(obj)
    self.TestFlag = obj.TestFlag
end

function TTestFlag:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTestFlag.group)
end

TTestFlag.from_obj = TTestFlag_from_obj

TTestFlag.proto_property = {'TestFlag'}

TTestFlag.default = {0}

TTestFlag.struct = {{name = 'TestFlag', is_array = false, struct = nil}}

function TTestFlag:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TestFlag', self.TestFlag, 'uint8', false, errs, need_convert)

    TTestFlag:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTestFlag.proto_property, errs, need_convert)
    return self
end

function TTestFlag:unpack(_)
    return self.TestFlag
end

MTestType.TestFlag = TTestFlag

---@class MTestType.Id
---@field Id string
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj MTestType.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {''}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'string', false, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

MTestType.Id = TId

return MTestType
