-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local mdb = require 'mc.mdb'
local class = require 'mc.class_mgnt'
local privilege = require 'mc.privilege'

local device_chip_class_types = require 'class.types.DeviceChip'
local test_type_class_types = require 'class.types.TestType'
local dft_cfg_mgmt_class_types = require 'class.types.DftCfgMgmt'

local DeviceChip = {
    ['prop_configs'] = {
        ['Chip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['refInterface'] = 'bmc.kepler.Accessor',
            ['validator'] = device_chip_class_types.Chip
        },
        ['DeviceType'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = device_chip_class_types.DeviceType},
        ['Slot'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = device_chip_class_types.Slot}
    },
    ['default_props'] = {
        ['Chip'] = device_chip_class_types.Chip.default[1],
        ['DeviceType'] = device_chip_class_types.DeviceType.default[1],
        ['Slot'] = device_chip_class_types.Slot.default[1]
    }
}

local TestType = {
    ['table_name'] = 't_test_type',
    ['prop_configs'] = {
        ['Id'] = {['primaryKey'] = true, ['baseType'] = 'String', ['validator'] = test_type_class_types.Id},
        ['TestFlag'] = {['baseType'] = 'U8', ['validator'] = test_type_class_types.TestFlag},
        ['TestType'] = {['baseType'] = 'U8', ['validator'] = test_type_class_types.TestType}
    },
    ['default_props'] = {
        ['Id'] = test_type_class_types.Id.default[1],
        ['TestFlag'] = test_type_class_types.TestFlag.default[1],
        ['TestType'] = test_type_class_types.TestType.default[1]
    }
}

local DftCfgMgmt = {
    ['prop_configs'] = {
        ['DftPackageFilename'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['default'] = '',
            ['description'] = '装备包名称',
            ['validator'] = dft_cfg_mgmt_class_types.DftPackageFilename
        }
    },
    ['default_props'] = {['DftPackageFilename'] = ''}
}

local M = {}

function M.init(bus)
    class('DeviceChip', DeviceChip):set_bus(bus)
    class('TestType', TestType):set_bus(bus)
    class('DftCfgMgmt', DftCfgMgmt):set_bus(bus)
end
return M
