-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local skynet = require 'skynet'
local log = require 'mc.logging'
local utils_core = require 'utils.core'
local launch_control = require 'mc.launch_control'

local M_ARENA_MAX<const> = -8
local M_TRIM_THRESHOLD<const> = -1

skynet.start(function()
    local module_name = skynet.getenv('MODULE_NAME')
    if type(module_name) == 'string' and module_name ~= '' then
        log:set_log_module_name(module_name)
    end

    -- 内存持续增长的glibc内存管理配置项设置
    -- M_ARENA_MAX: 最大ARENA数量,可以理解成进程拥有的堆内存池最大数量
    utils_core.mallopt(M_ARENA_MAX, 1)
    -- M_TRIM_THRESHOLD: 自动回收堆顶空闲内存空间给内核的阈值,单元:byte
    utils_core.mallopt(M_TRIM_THRESHOLD, 4 * 1024)

    skynet.fork(function()
        while true do
            utils_core.malloc_trim(0)
            skynet.sleep(5 * 60 * 100) -- 5分钟trim一次
        end
    end)

    skynet.uniqueservice('sd_bus')
    launch_control.launch_components('security')
end)
