#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright (c) 2024 Huawei Technologies Co., Ltd.
# openUBMC is licensed under Mulan PSL v2.
# You can use this software according to the terms and conditions of the Mulan PSL v2.
# You may obtain a copy of Mulan PSL v2 at:
#         http://license.coscl.org.cn/MulanPSL2
# THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
# EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
# MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
# See the Mulan PSL v2 for more details.
import sys

from conans import ConanFile, CMake, tools
import yaml


class OpenubmcConan(ConanFile):
    name = "openubmc"
    url = "https://www.huawei.com"
    settings = "os", "compiler", "build_type", "arch"
    requires = []
    license = "Mulan PSL v2"
    exports_sources = ["manifest.yml"]
    _manifest = None

    options = {"stage": ["dev", "rc", "stable"]}

    default_options = {"stage": "dev"}

    def init(self):
        with open("manifest.yml", "r") as fp:
            self._manifest = yaml.load(fp, yaml.FullLoader)

    def set_version(self):
        self.version = self._manifest["base"]["version"]

    def requirements(self):
        for dep in self._manifest.get("dependencies", {}):
            require = dep["conan"] + ""
            if self.options.stage == "rc":
                if require.endswith("dev"):
                    print("require {} format error, must end with rc".format(require))
                    sys.exit(-1)
            if self.options.stage == "stable":
                if not require.endswith("stable"):
                    print(
                        "require {} format error, must end with stable".format(require)
                    )
                    sys.exit(-1)

            self.requires(require)

    def build(self):
        pass

    def package(self):
        pass

    def package_info(self):
        pass

