-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local alarm = require 'alarm.alarm'
local defs = require 'domain.defs'
local event_util = require 'infrastructure.event'
local debug = require 'domain.debug.debug'
local monitor = require 'domain.debug.monitor'

TestAlarm = {}

function TestAlarm:test_event_util()
    local ok = pcall(event_util.generate_event)
    lu.assertEquals(ok,  false)
    ok, res = pcall(event_util.generate_event, {})
    lu.assertEquals(ok,  false)
    ok, res = pcall(event_util.generate_event, {ComponentName = 'BCUBoard'})
    lu.assertEquals(ok,  false)
end

function TestAlarm:test_get_msg_args()
    local alarm_instance = alarm.new()
    local res = alarm_instance:get_msg_args(defs.ALARM_TYPE.CHIP_ERR, 'a')
    lu.assertEquals(res, '["mainboard","a"]')
    res = alarm_instance:get_msg_args(defs.ALARM_TYPE.LSW_RECOVERY, 'b')
    lu.assertEquals(res, '["b"]')
end

function TestAlarm:test_generate_event()
    local alarm_instance = alarm.new()
    alarm_instance:event('', 0, 0, true)
    alarm_instance:event(defs.ALARM_TYPE.LSW_RECOVERY, 0, 0, true)
    event_util.generate_event = function()
        return ok
    end
    alarm_instance:event(defs.ALARM_TYPE.LSW_RECOVERY, 0, 0, false)
end

function TestAlarm:test_debug()
    local mgr = debug.get_instance()
    mgr:func_call(defs.DEBUG_FUNC.CHIP_REG_READ, 1, 1)
    mgr:update_lsw_type(1)
end

function TestAlarm:test_monitor()
    local mtr = monitor.get_instance()
    mtr:init_state()
    local res = mtr:get_config_errcode()
    lu.assertEquals(res, 255)
    -- 此UT发现代码问题
    res = mtr:get_config_state()
    lu.assertEquals(res, 'start')
    mtr:update_state(defs.NetConfigIdx.PortInit, true)
    mtr:update_state(defs.NetConfigIdx.PortInit, false)
    mtr:update_state(defs.NetConfigIdx.Finish)
    -- 此UT发现代码问题
    mtr:call_config(defs.NetConfigIdx.PortInit, function()
    end)
end