-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

function mock_func (...)
end

function mock_func_return (...)
    return 0
end

function mock_l_port_init (parent_type, unit, physicalId, portType)
    if type(unit) ~= "number" or type(physicalId) ~= "number" or 
        type(portType) ~= "number" then
            error("Invalid number type")
        end
    return 0
end

function mock_l_lsw_vlan_init (objtype, unit)
    if type(unit) ~= "number" then
            error("Invalid number type")
        end
    return 0
end

function mock_l_lsw_port_vlan_init (parent_type, unit, physicalId, pvid, accframetype)
    if type(unit) ~= "number" or type(physicalId) ~= "number" or
        type(pvid) ~= "number" or type(accframetype) ~= "number" then
            error("Invalid number type")
        end
    return 0
end

function mock_l_lsw_single_vlan_init (parent_type, unit, vlanid, member, untaged)
    if type(unit) ~= "number" or type(vlanid) ~= "number" or
        type(member) ~= "number" or type(untaged) ~= "number" then
            error("Invalid number type")
        end
    return 0
end


local lsw_drv = {
    l_getAsicReg = mock_func ,
    l_setAsicReg = mock_func ,
    l_port_phyReg_get = mock_func ,
    l_port_phyReg_set = mock_func ,
    l_bus_init = mock_func ,
    l_chip_init = mock_func ,
    l_phy_init = mock_func ,
    l_lsw_vlan_init = mock_l_lsw_vlan_init ,
    l_lsw_single_vlan_init = mock_l_lsw_single_vlan_init ,
    l_lsw_port_vlan_init = mock_l_lsw_port_vlan_init ,
    l_port_init = mock_l_port_init,
    l_lsw_switch_soft_reset = mock_func ,
    l_get_oem_type_by_unit = mock_func ,
    l_get_phy_type = mock_func ,
    l_get_port_status = mock_func ,
    l_rtl_8367_is_phy_abnormal = mock_func ,
    l_lsw_port_isolation_get = mock_func ,
    l_lsw_get_switch_port_auto_nego = mock_func ,
    l_lsw_stp_mstpState_get = mock_func ,
    l_rtl_8367_routine_port_pkt_cnt = mock_func,
    l_cfg_port_iso = mock_func ,
    l_cfg_port_storm = mock_func ,
    l_get_port_enable = mock_func ,
    l_set_port_enable = mock_func ,
    l_get_port_stp_state = mock_func ,
    l_set_port_stp_state = mock_func,
    l_get_switch_error_code = mock_func ,
    l_get_port_mac_info = mock_func ,
    l_set_port_mac_addr = mock_func ,
    l_get_port_l2_addr = mock_func ,
    l_flush_port_l2_addr = mock_func ,
}

return lsw_drv