-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local class = require 'mc.class'
local log = require 'mc.logging'
local phy = require 'domain.device.switch.phy.phy'
local phy_chip = class()

function phy_chip:ctor()
    self.component = {
        phys = {}
    }
    self.obj = {}
end

function phy_chip:add_object(obj)
    if self.component.phys[obj.PhysicalId] then
        return
    end
    self.component.phys[obj.PhysicalId] = phy.new(obj)
end

function phy_chip:start_init(is_fix)
    for _, v in pairs(self.component.phys) do
        v:start_init(is_fix)
    end
end

function phy_chip:hard_reset()
    for _, v in pairs(self.component.phys) do
        v:hard_reset()
    end
end

function phy_chip:soft_reset()
end

function phy_chip:get_phy_by_id(phy_id)
    for _, v in pairs(self.component.phys) do
        if v:get_prop('PhysicalAddr') == phy_id then
            return v
        end
    end
end

function phy_chip:healthy_check()
    for _, v in pairs(self.component.phys) do
        if not v:is_health() then
            log:debug("[lsw] phy chip is not healthy")
            return false
        end
    end
    return true
end

return phy_chip
