-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local defs = {}

defs.LSW_TYPE = {
    GE_SWITCHOEM_RTL8367 = 0x01,
    GE_SWITCHOEM_SF2507 = 0x02
}

defs.DEBUG_FUNC = {
    CHIP_REG_READ = 0x01,
    CHIP_REG_WRITE = 0x02,
    PORT_REG_READ = 0x03,
    PORT_REG_WRITE = 0x04,
    GET_PORT_ENABLE = 0x05,
    GET_PORT_STP_STATE = 0x06,
    GET_PORT_MAC_INFO = 0x07,
    GET_PORT_L2_ADDR = 0x08,
    SET_PORT_ENABLE = 0x09,
    SET_PORT_STP_STATE = 0x0A,
    GET_SWITCH_ERROR_CODE = 0x0B,
    SET_PORT_MAC_ADDR = 0x0C,
    FLUSH_PORT_ADDR = 0x0D
}

defs.RESET_TYPE = {
    HARD_RESET = 1,
    SOFT_RESET = 2
}

defs.LSW_DEVICE = {
    CHIP = 1,
    PHY = 2,
    ALL = 3
}

-- 外网通路与内网vlan对应关系
defs.ATLAS_VLAN = {
    [1] = 4090,
    [2] = 4091
}

defs.ALARM_TYPE = {
    PHY_ERR = 'PhyErr',
    CHIP_ERR = 'ChipFault',
    PHY_POWER_OFF = 'PhyPowerOff',
    LSW_POWER_OFF = 'LswPowerOff',
    LSW_RECOVERY = 'LswRecovery'
}

defs.LSW_POS = {
    MAIN_BOARD = 'mainboard'
}

defs.NetConfigIdx = {
    Start = 0,
    OnAddObject = 1,
    PortConnectPhy = 2,
    BusInit = 3,
    UpdateOemType = 4,
    ChipHardReset = 5,
    ChipInit = 6,
    PortInit = 7,
    PortIso = 8,
    PortStorm = 9,
    VlanInit = 10,
    SingleVlanInit = 11,
    PortVlanInit = 12,
    ExtVlanInit = 13,
    ChipSoftReset = 14,
    PhyHardReset = 15,
    UpdateType = 16,
    PhyInit = 17,
    CfgLinkUp = 18,
    Finish = 19
}

return defs