-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local LanSwitchMock = {}

---@class LanSwitchMock.GetVlanInfoRsp
---@field Value string
local TGetVlanInfoRsp = {}
TGetVlanInfoRsp.__index = TGetVlanInfoRsp
TGetVlanInfoRsp.group = {}

local function TGetVlanInfoRsp_from_obj(obj)
    return setmetatable(obj, TGetVlanInfoRsp)
end

function TGetVlanInfoRsp.new(Value)
    return TGetVlanInfoRsp_from_obj({Value = Value})
end
---@param obj LanSwitchMock.GetVlanInfoRsp
function TGetVlanInfoRsp:init_from_obj(obj)
    self.Value = obj.Value
end

function TGetVlanInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetVlanInfoRsp.group)
end

TGetVlanInfoRsp.from_obj = TGetVlanInfoRsp_from_obj

TGetVlanInfoRsp.proto_property = {'Value'}

TGetVlanInfoRsp.default = {''}

TGetVlanInfoRsp.struct = {{name = 'Value', is_array = false, struct = nil}}

function TGetVlanInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Value', self.Value, 'string', false, errs, need_convert)

    TGetVlanInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetVlanInfoRsp.proto_property, errs, need_convert)
    return self
end

function TGetVlanInfoRsp:unpack(_)
    return self.Value
end

LanSwitchMock.GetVlanInfoRsp = TGetVlanInfoRsp

---@class LanSwitchMock.GetVlanInfoReq
---@field Unit integer
local TGetVlanInfoReq = {}
TGetVlanInfoReq.__index = TGetVlanInfoReq
TGetVlanInfoReq.group = {}

local function TGetVlanInfoReq_from_obj(obj)
    return setmetatable(obj, TGetVlanInfoReq)
end

function TGetVlanInfoReq.new(Unit)
    return TGetVlanInfoReq_from_obj({Unit = Unit})
end
---@param obj LanSwitchMock.GetVlanInfoReq
function TGetVlanInfoReq:init_from_obj(obj)
    self.Unit = obj.Unit
end

function TGetVlanInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetVlanInfoReq.group)
end

TGetVlanInfoReq.from_obj = TGetVlanInfoReq_from_obj

TGetVlanInfoReq.proto_property = {'Unit'}

TGetVlanInfoReq.default = {0}

TGetVlanInfoReq.struct = {{name = 'Unit', is_array = false, struct = nil}}

function TGetVlanInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Unit', self.Unit, 'uint32', false, errs, need_convert)

    TGetVlanInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetVlanInfoReq.proto_property, errs, need_convert)
    return self
end

function TGetVlanInfoReq:unpack(_)
    return self.Unit
end

LanSwitchMock.GetVlanInfoReq = TGetVlanInfoReq

---@class LanSwitchMock.FlushPortAddrRsp
local TFlushPortAddrRsp = {}
TFlushPortAddrRsp.__index = TFlushPortAddrRsp
TFlushPortAddrRsp.group = {}

local function TFlushPortAddrRsp_from_obj(obj)
    return setmetatable(obj, TFlushPortAddrRsp)
end

function TFlushPortAddrRsp.new()
    return TFlushPortAddrRsp_from_obj({})
end
---@param obj LanSwitchMock.FlushPortAddrRsp
function TFlushPortAddrRsp:init_from_obj(obj)

end

function TFlushPortAddrRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFlushPortAddrRsp.group)
end

TFlushPortAddrRsp.from_obj = TFlushPortAddrRsp_from_obj

TFlushPortAddrRsp.proto_property = {}

TFlushPortAddrRsp.default = {}

TFlushPortAddrRsp.struct = {}

function TFlushPortAddrRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TFlushPortAddrRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFlushPortAddrRsp.proto_property, errs, need_convert)
    return self
end

function TFlushPortAddrRsp:unpack(_)
end

LanSwitchMock.FlushPortAddrRsp = TFlushPortAddrRsp

---@class LanSwitchMock.FlushPortAddrReq
---@field Unit integer
---@field Port integer
local TFlushPortAddrReq = {}
TFlushPortAddrReq.__index = TFlushPortAddrReq
TFlushPortAddrReq.group = {}

local function TFlushPortAddrReq_from_obj(obj)
    return setmetatable(obj, TFlushPortAddrReq)
end

function TFlushPortAddrReq.new(Unit, Port)
    return TFlushPortAddrReq_from_obj({Unit = Unit, Port = Port})
end
---@param obj LanSwitchMock.FlushPortAddrReq
function TFlushPortAddrReq:init_from_obj(obj)
    self.Unit = obj.Unit
    self.Port = obj.Port
end

function TFlushPortAddrReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFlushPortAddrReq.group)
end

TFlushPortAddrReq.from_obj = TFlushPortAddrReq_from_obj

TFlushPortAddrReq.proto_property = {'Unit', 'Port'}

TFlushPortAddrReq.default = {0, 0}

TFlushPortAddrReq.struct = {
    {name = 'Unit', is_array = false, struct = nil}, {name = 'Port', is_array = false, struct = nil}
}

function TFlushPortAddrReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Unit', self.Unit, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Port', self.Port, 'uint32', false, errs, need_convert)

    TFlushPortAddrReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFlushPortAddrReq.proto_property, errs, need_convert)
    return self
end

function TFlushPortAddrReq:unpack(_)
    return self.Unit, self.Port
end

LanSwitchMock.FlushPortAddrReq = TFlushPortAddrReq

---@class LanSwitchMock.SetPortMacAddrRsp
local TSetPortMacAddrRsp = {}
TSetPortMacAddrRsp.__index = TSetPortMacAddrRsp
TSetPortMacAddrRsp.group = {}

local function TSetPortMacAddrRsp_from_obj(obj)
    return setmetatable(obj, TSetPortMacAddrRsp)
end

function TSetPortMacAddrRsp.new()
    return TSetPortMacAddrRsp_from_obj({})
end
---@param obj LanSwitchMock.SetPortMacAddrRsp
function TSetPortMacAddrRsp:init_from_obj(obj)

end

function TSetPortMacAddrRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPortMacAddrRsp.group)
end

TSetPortMacAddrRsp.from_obj = TSetPortMacAddrRsp_from_obj

TSetPortMacAddrRsp.proto_property = {}

TSetPortMacAddrRsp.default = {}

TSetPortMacAddrRsp.struct = {}

function TSetPortMacAddrRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetPortMacAddrRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPortMacAddrRsp.proto_property, errs, need_convert)
    return self
end

function TSetPortMacAddrRsp:unpack(_)
end

LanSwitchMock.SetPortMacAddrRsp = TSetPortMacAddrRsp

---@class LanSwitchMock.SetPortMacAddrReq
---@field Unit integer
---@field Port integer
---@field MacStr string
local TSetPortMacAddrReq = {}
TSetPortMacAddrReq.__index = TSetPortMacAddrReq
TSetPortMacAddrReq.group = {}

local function TSetPortMacAddrReq_from_obj(obj)
    return setmetatable(obj, TSetPortMacAddrReq)
end

function TSetPortMacAddrReq.new(Unit, Port, MacStr)
    return TSetPortMacAddrReq_from_obj({Unit = Unit, Port = Port, MacStr = MacStr})
end
---@param obj LanSwitchMock.SetPortMacAddrReq
function TSetPortMacAddrReq:init_from_obj(obj)
    self.Unit = obj.Unit
    self.Port = obj.Port
    self.MacStr = obj.MacStr
end

function TSetPortMacAddrReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPortMacAddrReq.group)
end

TSetPortMacAddrReq.from_obj = TSetPortMacAddrReq_from_obj

TSetPortMacAddrReq.proto_property = {'Unit', 'Port', 'MacStr'}

TSetPortMacAddrReq.default = {0, 0, ''}

TSetPortMacAddrReq.struct = {
    {name = 'Unit', is_array = false, struct = nil}, {name = 'Port', is_array = false, struct = nil},
    {name = 'MacStr', is_array = false, struct = nil}
}

function TSetPortMacAddrReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Unit', self.Unit, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Port', self.Port, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'MacStr', self.MacStr, 'string', false, errs, need_convert)

    TSetPortMacAddrReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPortMacAddrReq.proto_property, errs, need_convert)
    return self
end

function TSetPortMacAddrReq:unpack(_)
    return self.Unit, self.Port, self.MacStr
end

LanSwitchMock.SetPortMacAddrReq = TSetPortMacAddrReq

---@class LanSwitchMock.GetSwitchErrorCodeRsp
---@field Value integer
local TGetSwitchErrorCodeRsp = {}
TGetSwitchErrorCodeRsp.__index = TGetSwitchErrorCodeRsp
TGetSwitchErrorCodeRsp.group = {}

local function TGetSwitchErrorCodeRsp_from_obj(obj)
    return setmetatable(obj, TGetSwitchErrorCodeRsp)
end

function TGetSwitchErrorCodeRsp.new(Value)
    return TGetSwitchErrorCodeRsp_from_obj({Value = Value})
end
---@param obj LanSwitchMock.GetSwitchErrorCodeRsp
function TGetSwitchErrorCodeRsp:init_from_obj(obj)
    self.Value = obj.Value
end

function TGetSwitchErrorCodeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSwitchErrorCodeRsp.group)
end

TGetSwitchErrorCodeRsp.from_obj = TGetSwitchErrorCodeRsp_from_obj

TGetSwitchErrorCodeRsp.proto_property = {'Value'}

TGetSwitchErrorCodeRsp.default = {0}

TGetSwitchErrorCodeRsp.struct = {{name = 'Value', is_array = false, struct = nil}}

function TGetSwitchErrorCodeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Value', self.Value, 'uint32', false, errs, need_convert)

    TGetSwitchErrorCodeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSwitchErrorCodeRsp.proto_property, errs, need_convert)
    return self
end

function TGetSwitchErrorCodeRsp:unpack(_)
    return self.Value
end

LanSwitchMock.GetSwitchErrorCodeRsp = TGetSwitchErrorCodeRsp

---@class LanSwitchMock.GetSwitchErrorCodeReq
---@field Unit integer
---@field UtpNum integer
local TGetSwitchErrorCodeReq = {}
TGetSwitchErrorCodeReq.__index = TGetSwitchErrorCodeReq
TGetSwitchErrorCodeReq.group = {}

local function TGetSwitchErrorCodeReq_from_obj(obj)
    return setmetatable(obj, TGetSwitchErrorCodeReq)
end

function TGetSwitchErrorCodeReq.new(Unit, UtpNum)
    return TGetSwitchErrorCodeReq_from_obj({Unit = Unit, UtpNum = UtpNum})
end
---@param obj LanSwitchMock.GetSwitchErrorCodeReq
function TGetSwitchErrorCodeReq:init_from_obj(obj)
    self.Unit = obj.Unit
    self.UtpNum = obj.UtpNum
end

function TGetSwitchErrorCodeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetSwitchErrorCodeReq.group)
end

TGetSwitchErrorCodeReq.from_obj = TGetSwitchErrorCodeReq_from_obj

TGetSwitchErrorCodeReq.proto_property = {'Unit', 'UtpNum'}

TGetSwitchErrorCodeReq.default = {0, 0}

TGetSwitchErrorCodeReq.struct = {
    {name = 'Unit', is_array = false, struct = nil}, {name = 'UtpNum', is_array = false, struct = nil}
}

function TGetSwitchErrorCodeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Unit', self.Unit, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'UtpNum', self.UtpNum, 'uint32', false, errs, need_convert)

    TGetSwitchErrorCodeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetSwitchErrorCodeReq.proto_property, errs, need_convert)
    return self
end

function TGetSwitchErrorCodeReq:unpack(_)
    return self.Unit, self.UtpNum
end

LanSwitchMock.GetSwitchErrorCodeReq = TGetSwitchErrorCodeReq

---@class LanSwitchMock.SetPortStpStateRsp
local TSetPortStpStateRsp = {}
TSetPortStpStateRsp.__index = TSetPortStpStateRsp
TSetPortStpStateRsp.group = {}

local function TSetPortStpStateRsp_from_obj(obj)
    return setmetatable(obj, TSetPortStpStateRsp)
end

function TSetPortStpStateRsp.new()
    return TSetPortStpStateRsp_from_obj({})
end
---@param obj LanSwitchMock.SetPortStpStateRsp
function TSetPortStpStateRsp:init_from_obj(obj)

end

function TSetPortStpStateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPortStpStateRsp.group)
end

TSetPortStpStateRsp.from_obj = TSetPortStpStateRsp_from_obj

TSetPortStpStateRsp.proto_property = {}

TSetPortStpStateRsp.default = {}

TSetPortStpStateRsp.struct = {}

function TSetPortStpStateRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetPortStpStateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPortStpStateRsp.proto_property, errs, need_convert)
    return self
end

function TSetPortStpStateRsp:unpack(_)
end

LanSwitchMock.SetPortStpStateRsp = TSetPortStpStateRsp

---@class LanSwitchMock.SetPortStpStateReq
---@field Unit integer
---@field Port integer
---@field State integer
local TSetPortStpStateReq = {}
TSetPortStpStateReq.__index = TSetPortStpStateReq
TSetPortStpStateReq.group = {}

local function TSetPortStpStateReq_from_obj(obj)
    return setmetatable(obj, TSetPortStpStateReq)
end

function TSetPortStpStateReq.new(Unit, Port, State)
    return TSetPortStpStateReq_from_obj({Unit = Unit, Port = Port, State = State})
end
---@param obj LanSwitchMock.SetPortStpStateReq
function TSetPortStpStateReq:init_from_obj(obj)
    self.Unit = obj.Unit
    self.Port = obj.Port
    self.State = obj.State
end

function TSetPortStpStateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPortStpStateReq.group)
end

TSetPortStpStateReq.from_obj = TSetPortStpStateReq_from_obj

TSetPortStpStateReq.proto_property = {'Unit', 'Port', 'State'}

TSetPortStpStateReq.default = {0, 0, 0}

TSetPortStpStateReq.struct = {
    {name = 'Unit', is_array = false, struct = nil}, {name = 'Port', is_array = false, struct = nil},
    {name = 'State', is_array = false, struct = nil}
}

function TSetPortStpStateReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Unit', self.Unit, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Port', self.Port, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'State', self.State, 'uint32', false, errs, need_convert)

    TSetPortStpStateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPortStpStateReq.proto_property, errs, need_convert)
    return self
end

function TSetPortStpStateReq:unpack(_)
    return self.Unit, self.Port, self.State
end

LanSwitchMock.SetPortStpStateReq = TSetPortStpStateReq

---@class LanSwitchMock.SetPortEnableRsp
local TSetPortEnableRsp = {}
TSetPortEnableRsp.__index = TSetPortEnableRsp
TSetPortEnableRsp.group = {}

local function TSetPortEnableRsp_from_obj(obj)
    return setmetatable(obj, TSetPortEnableRsp)
end

function TSetPortEnableRsp.new()
    return TSetPortEnableRsp_from_obj({})
end
---@param obj LanSwitchMock.SetPortEnableRsp
function TSetPortEnableRsp:init_from_obj(obj)

end

function TSetPortEnableRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPortEnableRsp.group)
end

TSetPortEnableRsp.from_obj = TSetPortEnableRsp_from_obj

TSetPortEnableRsp.proto_property = {}

TSetPortEnableRsp.default = {}

TSetPortEnableRsp.struct = {}

function TSetPortEnableRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetPortEnableRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPortEnableRsp.proto_property, errs, need_convert)
    return self
end

function TSetPortEnableRsp:unpack(_)
end

LanSwitchMock.SetPortEnableRsp = TSetPortEnableRsp

---@class LanSwitchMock.SetPortEnableReq
---@field Unit integer
---@field Port integer
---@field Enable integer
local TSetPortEnableReq = {}
TSetPortEnableReq.__index = TSetPortEnableReq
TSetPortEnableReq.group = {}

local function TSetPortEnableReq_from_obj(obj)
    return setmetatable(obj, TSetPortEnableReq)
end

function TSetPortEnableReq.new(Unit, Port, Enable)
    return TSetPortEnableReq_from_obj({Unit = Unit, Port = Port, Enable = Enable})
end
---@param obj LanSwitchMock.SetPortEnableReq
function TSetPortEnableReq:init_from_obj(obj)
    self.Unit = obj.Unit
    self.Port = obj.Port
    self.Enable = obj.Enable
end

function TSetPortEnableReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPortEnableReq.group)
end

TSetPortEnableReq.from_obj = TSetPortEnableReq_from_obj

TSetPortEnableReq.proto_property = {'Unit', 'Port', 'Enable'}

TSetPortEnableReq.default = {0, 0, 0}

TSetPortEnableReq.struct = {
    {name = 'Unit', is_array = false, struct = nil}, {name = 'Port', is_array = false, struct = nil},
    {name = 'Enable', is_array = false, struct = nil}
}

function TSetPortEnableReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Unit', self.Unit, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Port', self.Port, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Enable', self.Enable, 'uint32', false, errs, need_convert)

    TSetPortEnableReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPortEnableReq.proto_property, errs, need_convert)
    return self
end

function TSetPortEnableReq:unpack(_)
    return self.Unit, self.Port, self.Enable
end

LanSwitchMock.SetPortEnableReq = TSetPortEnableReq

---@class LanSwitchMock.GetPortInfoRsp
---@field Value string
local TGetPortInfoRsp = {}
TGetPortInfoRsp.__index = TGetPortInfoRsp
TGetPortInfoRsp.group = {}

local function TGetPortInfoRsp_from_obj(obj)
    return setmetatable(obj, TGetPortInfoRsp)
end

function TGetPortInfoRsp.new(Value)
    return TGetPortInfoRsp_from_obj({Value = Value})
end
---@param obj LanSwitchMock.GetPortInfoRsp
function TGetPortInfoRsp:init_from_obj(obj)
    self.Value = obj.Value
end

function TGetPortInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPortInfoRsp.group)
end

TGetPortInfoRsp.from_obj = TGetPortInfoRsp_from_obj

TGetPortInfoRsp.proto_property = {'Value'}

TGetPortInfoRsp.default = {''}

TGetPortInfoRsp.struct = {{name = 'Value', is_array = false, struct = nil}}

function TGetPortInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Value', self.Value, 'string', false, errs, need_convert)

    TGetPortInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPortInfoRsp.proto_property, errs, need_convert)
    return self
end

function TGetPortInfoRsp:unpack(_)
    return self.Value
end

LanSwitchMock.GetPortInfoRsp = TGetPortInfoRsp

---@class LanSwitchMock.GetPortInfoReq
---@field Unit integer
---@field Port integer
local TGetPortInfoReq = {}
TGetPortInfoReq.__index = TGetPortInfoReq
TGetPortInfoReq.group = {}

local function TGetPortInfoReq_from_obj(obj)
    return setmetatable(obj, TGetPortInfoReq)
end

function TGetPortInfoReq.new(Unit, Port)
    return TGetPortInfoReq_from_obj({Unit = Unit, Port = Port})
end
---@param obj LanSwitchMock.GetPortInfoReq
function TGetPortInfoReq:init_from_obj(obj)
    self.Unit = obj.Unit
    self.Port = obj.Port
end

function TGetPortInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPortInfoReq.group)
end

TGetPortInfoReq.from_obj = TGetPortInfoReq_from_obj

TGetPortInfoReq.proto_property = {'Unit', 'Port'}

TGetPortInfoReq.default = {0, 0}

TGetPortInfoReq.struct = {
    {name = 'Unit', is_array = false, struct = nil}, {name = 'Port', is_array = false, struct = nil}
}

function TGetPortInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Unit', self.Unit, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Port', self.Port, 'uint32', false, errs, need_convert)

    TGetPortInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPortInfoReq.proto_property, errs, need_convert)
    return self
end

function TGetPortInfoReq:unpack(_)
    return self.Unit, self.Port
end

LanSwitchMock.GetPortInfoReq = TGetPortInfoReq

---@class LanSwitchMock.RegWriteRsp
local TRegWriteRsp = {}
TRegWriteRsp.__index = TRegWriteRsp
TRegWriteRsp.group = {}

local function TRegWriteRsp_from_obj(obj)
    return setmetatable(obj, TRegWriteRsp)
end

function TRegWriteRsp.new()
    return TRegWriteRsp_from_obj({})
end
---@param obj LanSwitchMock.RegWriteRsp
function TRegWriteRsp:init_from_obj(obj)

end

function TRegWriteRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRegWriteRsp.group)
end

TRegWriteRsp.from_obj = TRegWriteRsp_from_obj

TRegWriteRsp.proto_property = {}

TRegWriteRsp.default = {}

TRegWriteRsp.struct = {}

function TRegWriteRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TRegWriteRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRegWriteRsp.proto_property, errs, need_convert)
    return self
end

function TRegWriteRsp:unpack(_)
end

LanSwitchMock.RegWriteRsp = TRegWriteRsp

---@class LanSwitchMock.RegWriteReq
---@field Unit integer
---@field Type integer
---@field Port integer
---@field Addr integer
---@field Value integer
local TRegWriteReq = {}
TRegWriteReq.__index = TRegWriteReq
TRegWriteReq.group = {}

local function TRegWriteReq_from_obj(obj)
    return setmetatable(obj, TRegWriteReq)
end

function TRegWriteReq.new(Unit, Type, Port, Addr, Value)
    return TRegWriteReq_from_obj({Unit = Unit, Type = Type, Port = Port, Addr = Addr, Value = Value})
end
---@param obj LanSwitchMock.RegWriteReq
function TRegWriteReq:init_from_obj(obj)
    self.Unit = obj.Unit
    self.Type = obj.Type
    self.Port = obj.Port
    self.Addr = obj.Addr
    self.Value = obj.Value
end

function TRegWriteReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRegWriteReq.group)
end

TRegWriteReq.from_obj = TRegWriteReq_from_obj

TRegWriteReq.proto_property = {'Unit', 'Type', 'Port', 'Addr', 'Value'}

TRegWriteReq.default = {0, 0, 0, 0, 0}

TRegWriteReq.struct = {
    {name = 'Unit', is_array = false, struct = nil}, {name = 'Type', is_array = false, struct = nil},
    {name = 'Port', is_array = false, struct = nil}, {name = 'Addr', is_array = false, struct = nil},
    {name = 'Value', is_array = false, struct = nil}
}

function TRegWriteReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Unit', self.Unit, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Type', self.Type, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Port', self.Port, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Addr', self.Addr, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Value', self.Value, 'uint32', false, errs, need_convert)

    TRegWriteReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRegWriteReq.proto_property, errs, need_convert)
    return self
end

function TRegWriteReq:unpack(_)
    return self.Unit, self.Type, self.Port, self.Addr, self.Value
end

LanSwitchMock.RegWriteReq = TRegWriteReq

---@class LanSwitchMock.RegReadRsp
---@field Value integer
local TRegReadRsp = {}
TRegReadRsp.__index = TRegReadRsp
TRegReadRsp.group = {}

local function TRegReadRsp_from_obj(obj)
    return setmetatable(obj, TRegReadRsp)
end

function TRegReadRsp.new(Value)
    return TRegReadRsp_from_obj({Value = Value})
end
---@param obj LanSwitchMock.RegReadRsp
function TRegReadRsp:init_from_obj(obj)
    self.Value = obj.Value
end

function TRegReadRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRegReadRsp.group)
end

TRegReadRsp.from_obj = TRegReadRsp_from_obj

TRegReadRsp.proto_property = {'Value'}

TRegReadRsp.default = {0}

TRegReadRsp.struct = {{name = 'Value', is_array = false, struct = nil}}

function TRegReadRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Value', self.Value, 'uint32', false, errs, need_convert)

    TRegReadRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRegReadRsp.proto_property, errs, need_convert)
    return self
end

function TRegReadRsp:unpack(_)
    return self.Value
end

LanSwitchMock.RegReadRsp = TRegReadRsp

---@class LanSwitchMock.RegReadReq
---@field Unit integer
---@field Type integer
---@field Port integer
---@field Addr integer
local TRegReadReq = {}
TRegReadReq.__index = TRegReadReq
TRegReadReq.group = {}

local function TRegReadReq_from_obj(obj)
    return setmetatable(obj, TRegReadReq)
end

function TRegReadReq.new(Unit, Type, Port, Addr)
    return TRegReadReq_from_obj({Unit = Unit, Type = Type, Port = Port, Addr = Addr})
end
---@param obj LanSwitchMock.RegReadReq
function TRegReadReq:init_from_obj(obj)
    self.Unit = obj.Unit
    self.Type = obj.Type
    self.Port = obj.Port
    self.Addr = obj.Addr
end

function TRegReadReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRegReadReq.group)
end

TRegReadReq.from_obj = TRegReadReq_from_obj

TRegReadReq.proto_property = {'Unit', 'Type', 'Port', 'Addr'}

TRegReadReq.default = {0, 0, 0, 0}

TRegReadReq.struct = {
    {name = 'Unit', is_array = false, struct = nil}, {name = 'Type', is_array = false, struct = nil},
    {name = 'Port', is_array = false, struct = nil}, {name = 'Addr', is_array = false, struct = nil}
}

function TRegReadReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Unit', self.Unit, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Type', self.Type, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Port', self.Port, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Addr', self.Addr, 'uint32', false, errs, need_convert)

    TRegReadReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRegReadReq.proto_property, errs, need_convert)
    return self
end

function TRegReadReq:unpack(_)
    return self.Unit, self.Type, self.Port, self.Addr
end

LanSwitchMock.RegReadReq = TRegReadReq

LanSwitchMock.interface = mdb.register_interface('bmc.kepler.Debug.LanSwitchMock', {}, {
    RegRead = {'a{ss}yyyu', 'u', TRegReadReq, TRegReadRsp},
    RegWrite = {'a{ss}yyyuu', '', TRegWriteReq, TRegWriteRsp},
    GetPortInfo = {'a{ss}uu', 's', TGetPortInfoReq, TGetPortInfoRsp},
    SetPortEnable = {'a{ss}uuu', '', TSetPortEnableReq, TSetPortEnableRsp},
    SetPortStpState = {'a{ss}uuu', '', TSetPortStpStateReq, TSetPortStpStateRsp},
    GetSwitchErrorCode = {'a{ss}uu', 'u', TGetSwitchErrorCodeReq, TGetSwitchErrorCodeRsp},
    SetPortMacAddr = {'a{ss}uus', '', TSetPortMacAddrReq, TSetPortMacAddrRsp},
    FlushPortAddr = {'a{ss}uu', '', TFlushPortAddrReq, TFlushPortAddrRsp},
    GetVlanInfo = {'a{ss}u', 's', TGetVlanInfoReq, TGetVlanInfoRsp}
}, {})

return LanSwitchMock
