-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local LanSwitch = {}

---@class LanSwitch.GetConfigInfoRsp
---@field Value string
local TGetConfigInfoRsp = {}
TGetConfigInfoRsp.__index = TGetConfigInfoRsp
TGetConfigInfoRsp.group = {}

local function TGetConfigInfoRsp_from_obj(obj)
    return setmetatable(obj, TGetConfigInfoRsp)
end

function TGetConfigInfoRsp.new(Value)
    return TGetConfigInfoRsp_from_obj({Value = Value})
end
---@param obj LanSwitch.GetConfigInfoRsp
function TGetConfigInfoRsp:init_from_obj(obj)
    self.Value = obj.Value
end

function TGetConfigInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetConfigInfoRsp.group)
end

TGetConfigInfoRsp.from_obj = TGetConfigInfoRsp_from_obj

TGetConfigInfoRsp.proto_property = {'Value'}

TGetConfigInfoRsp.default = {''}

TGetConfigInfoRsp.struct = {{name = 'Value', is_array = false, struct = nil}}

function TGetConfigInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Value', self.Value, 'string', false, errs, need_convert)

    TGetConfigInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetConfigInfoRsp.proto_property, errs, need_convert)
    return self
end

function TGetConfigInfoRsp:unpack(_)
    return self.Value
end

LanSwitch.GetConfigInfoRsp = TGetConfigInfoRsp

---@class LanSwitch.GetConfigInfoReq
local TGetConfigInfoReq = {}
TGetConfigInfoReq.__index = TGetConfigInfoReq
TGetConfigInfoReq.group = {}

local function TGetConfigInfoReq_from_obj(obj)
    return setmetatable(obj, TGetConfigInfoReq)
end

function TGetConfigInfoReq.new()
    return TGetConfigInfoReq_from_obj({})
end
---@param obj LanSwitch.GetConfigInfoReq
function TGetConfigInfoReq:init_from_obj(obj)

end

function TGetConfigInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetConfigInfoReq.group)
end

TGetConfigInfoReq.from_obj = TGetConfigInfoReq_from_obj

TGetConfigInfoReq.proto_property = {}

TGetConfigInfoReq.default = {}

TGetConfigInfoReq.struct = {}

function TGetConfigInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetConfigInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetConfigInfoReq.proto_property, errs, need_convert)
    return self
end

function TGetConfigInfoReq:unpack(_)
end

LanSwitch.GetConfigInfoReq = TGetConfigInfoReq

---@class LanSwitch.LswResetRsp
local TLswResetRsp = {}
TLswResetRsp.__index = TLswResetRsp
TLswResetRsp.group = {}

local function TLswResetRsp_from_obj(obj)
    return setmetatable(obj, TLswResetRsp)
end

function TLswResetRsp.new()
    return TLswResetRsp_from_obj({})
end
---@param obj LanSwitch.LswResetRsp
function TLswResetRsp:init_from_obj(obj)

end

function TLswResetRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLswResetRsp.group)
end

TLswResetRsp.from_obj = TLswResetRsp_from_obj

TLswResetRsp.proto_property = {}

TLswResetRsp.default = {}

TLswResetRsp.struct = {}

function TLswResetRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TLswResetRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLswResetRsp.proto_property, errs, need_convert)
    return self
end

function TLswResetRsp:unpack(_)
end

LanSwitch.LswResetRsp = TLswResetRsp

---@class LanSwitch.LswResetReq
---@field Device integer
---@field Type integer
local TLswResetReq = {}
TLswResetReq.__index = TLswResetReq
TLswResetReq.group = {}

local function TLswResetReq_from_obj(obj)
    return setmetatable(obj, TLswResetReq)
end

function TLswResetReq.new(Device, Type)
    return TLswResetReq_from_obj({Device = Device, Type = Type})
end
---@param obj LanSwitch.LswResetReq
function TLswResetReq:init_from_obj(obj)
    self.Device = obj.Device
    self.Type = obj.Type
end

function TLswResetReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLswResetReq.group)
end

TLswResetReq.from_obj = TLswResetReq_from_obj

TLswResetReq.proto_property = {'Device', 'Type'}

TLswResetReq.default = {0, 0}

TLswResetReq.struct = {
    {name = 'Device', is_array = false, struct = nil}, {name = 'Type', is_array = false, struct = nil}
}

function TLswResetReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Device', self.Device, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Type', self.Type, 'uint32', false, errs, need_convert)

    TLswResetReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLswResetReq.proto_property, errs, need_convert)
    return self
end

function TLswResetReq:unpack(_)
    return self.Device, self.Type
end

LanSwitch.LswResetReq = TLswResetReq

LanSwitch.interface = mdb.register_interface('bmc.kepler.Chassis.LanSwitch', {}, {
    LswReset = {'a{ss}uu', '', TLswResetReq, TLswResetRsp},
    GetConfigInfo = {'a{ss}', 's', TGetConfigInfoReq, TGetConfigInfoRsp}
}, {})

return LanSwitch
