--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local bs = require 'mc.bitstring'
local enums = require 'ipmi.enums'
local ipmi = require 'ipmi'
local types = require 'ipmi.types'
local privilege = require 'mc.privilege'
local msg = require 'lsw.ipmi.ipmi_message'

local CT = enums.ChannelType

local LswIpmiCmds = {}

LswIpmiCmds.GetPortLinkStatus = {
    name = 'GetPortLinkStatus',
    prio = types.Priority.OEM,
    netfn = 0x32,
    cmd = 0x8a,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<FruId:3/unit:8, PortId:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, LinkStates:1/unit:8, 0x]=] .. [=[000000:3/unit:8>>]=],
    req = msg.GetPortLinkStatusReq,
    rsp = msg.GetPortLinkStatusRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

LswIpmiCmds.GetPortSpeed = {
    name = 'GetPortSpeed',
    prio = types.Priority.OEM,
    netfn = 0x32,
    cmd = 0x8b,
    role = types.Role.User,
    privilege = privilege.ReadOnly,
    sensitive = false,
    restricted_channels = {},
    filters = [=[]=],
    decode = [=[<<FruId:3/unit:8, PortId:1/unit:8>>]=],
    encode = [=[<<CompletionCode:1/unit:8, SpeedLsb:1/unit:8, Spee]=] ..
        [=[dMsb:1/unit:8, AutoNego:1/unit:8, Duplex:1/unit:8>]=] .. [=[>]=],
    req = msg.GetPortSpeedReq,
    rsp = msg.GetPortSpeedRsp,
    manufacturer = {-1, -1},
    sysLockedPolicy = 'Allowed'
}

return LswIpmiCmds
