--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetPortSpeed = {}

---@class LswIpmiCmds.GetPortSpeedReq
---@field FruId integer
---@field PortId integer
local TGetPortSpeedReq = {}
TGetPortSpeedReq.__index = TGetPortSpeedReq
TGetPortSpeedReq.group = {}

local function TGetPortSpeedReq_from_obj(obj)
    return setmetatable(obj, TGetPortSpeedReq)
end

function TGetPortSpeedReq.new(FruId, PortId)
    return TGetPortSpeedReq_from_obj({FruId = FruId, PortId = PortId})
end
---@param obj LswIpmiCmds.GetPortSpeedReq
function TGetPortSpeedReq:init_from_obj(obj)
    self.FruId = obj.FruId
    self.PortId = obj.PortId
end

function TGetPortSpeedReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPortSpeedReq.group)
end

TGetPortSpeedReq.from_obj = TGetPortSpeedReq_from_obj

TGetPortSpeedReq.proto_property = {'FruId', 'PortId'}

TGetPortSpeedReq.default = {0, 0}

TGetPortSpeedReq.struct = {
    {name = 'FruId', is_array = false, struct = nil}, {name = 'PortId', is_array = false, struct = nil}
}

function TGetPortSpeedReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruId', self.FruId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'PortId', self.PortId, 'uint8', false, errs, need_convert)

    TGetPortSpeedReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPortSpeedReq.proto_property, errs, need_convert)
    return self
end

function TGetPortSpeedReq:unpack(_)
    return self.FruId, self.PortId
end

GetPortSpeed.GetPortSpeedReq = TGetPortSpeedReq

---@class LswIpmiCmds.GetPortSpeedRsp
---@field CompletionCode integer
---@field SpeedLsb integer
---@field SpeedMsb integer
---@field AutoNego integer
---@field Duplex integer
local TGetPortSpeedRsp = {}
TGetPortSpeedRsp.__index = TGetPortSpeedRsp
TGetPortSpeedRsp.group = {}

local function TGetPortSpeedRsp_from_obj(obj)
    return setmetatable(obj, TGetPortSpeedRsp)
end

function TGetPortSpeedRsp.new(CompletionCode, SpeedLsb, SpeedMsb, AutoNego, Duplex)
    return TGetPortSpeedRsp_from_obj({
        CompletionCode = CompletionCode,
        SpeedLsb = SpeedLsb,
        SpeedMsb = SpeedMsb,
        AutoNego = AutoNego,
        Duplex = Duplex
    })
end
---@param obj LswIpmiCmds.GetPortSpeedRsp
function TGetPortSpeedRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.SpeedLsb = obj.SpeedLsb
    self.SpeedMsb = obj.SpeedMsb
    self.AutoNego = obj.AutoNego
    self.Duplex = obj.Duplex
end

function TGetPortSpeedRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPortSpeedRsp.group)
end

TGetPortSpeedRsp.from_obj = TGetPortSpeedRsp_from_obj

TGetPortSpeedRsp.proto_property = {'CompletionCode', 'SpeedLsb', 'SpeedMsb', 'AutoNego', 'Duplex'}

TGetPortSpeedRsp.default = {0, 0, 0, 0, 0}

TGetPortSpeedRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'SpeedLsb', is_array = false, struct = nil},
    {name = 'SpeedMsb', is_array = false, struct = nil}, {name = 'AutoNego', is_array = false, struct = nil},
    {name = 'Duplex', is_array = false, struct = nil}
}

function TGetPortSpeedRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SpeedLsb', self.SpeedLsb, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SpeedMsb', self.SpeedMsb, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'AutoNego', self.AutoNego, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Duplex', self.Duplex, 'uint8', false, errs, need_convert)

    TGetPortSpeedRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPortSpeedRsp.proto_property, errs, need_convert)
    return self
end

function TGetPortSpeedRsp:unpack(_)
    return self.CompletionCode, self.SpeedLsb, self.SpeedMsb, self.AutoNego, self.Duplex
end

GetPortSpeed.GetPortSpeedRsp = TGetPortSpeedRsp

return GetPortSpeed
