-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local Databases = require 'database'
local Col = require 'database.column'

---@class LswInfoTable: Table
---@field Unit FieldBase
---@field IsCfg FieldBase

---@class SmmMsgTable: Table
---@field Unit FieldBase
---@field SMMLinkPath FieldBase
---@field ExternalVlanId FieldBase

---@class LswDBDatabase
---@field db DataBase
---@field select fun(db:DataBase, table: any, ...): SelectStatement
---@field update fun(db:DataBase, table: any, ...): UpdateStatement
---@field insert fun(db:DataBase, table: any, ...): InsertStatement
---@field LswInfo LswInfoTable
---@field SmmMsg SmmMsgTable
local LswDBDatabase = {}
LswDBDatabase.__index = LswDBDatabase

function LswDBDatabase.new(path, datas)
    local db = Databases(path)
    local obj = {db = db}

    obj.LswInfo = db:Table('t_lsw_info', {
        Unit = Col.IntegerField():cid(1):primary_key():max_length(32),
        IsCfg = Col.BooleandField():cid(2):default(false)
    }, 'protect_reset'):create_if_not_exist(datas and datas['t_lsw_info'])
    obj.SmmMsg = db:Table('t_smm_info', {
        Unit = Col.IntegerField():cid(1):primary_key():max_length(32),
        SMMLinkPath = Col.IntegerField():cid(2):max_length(8):default(0),
        ExternalVlanId = Col.IntegerField():cid(3):max_length(32):default(0)
    }, 'protect_power_off'):create_if_not_exist(datas and datas['t_smm_info'])

    obj.tables = db.tables
    return setmetatable(obj, LswDBDatabase)
end

function LswDBDatabase:select(table, ...)
    return self.db:select(table, ...)
end

function LswDBDatabase:update(table, ...)
    return self.db:update(table, ...)
end

function LswDBDatabase:insert(table, ...)
    return self.db:insert(table, ...)
end

function LswDBDatabase:delete(table, ...)
    return self.db:delete(table, ...)
end

function LswDBDatabase:exec(...)
    return self.db:exec(...)
end

return LswDBDatabase.new
