-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MLswSwitchInfo = {}

---@class MLswSwitchInfo.SlotNumber
---@field SlotNumber integer
local TSlotNumber = {}
TSlotNumber.__index = TSlotNumber
TSlotNumber.group = {}

local function TSlotNumber_from_obj(obj)
    return setmetatable(obj, TSlotNumber)
end

function TSlotNumber.new(SlotNumber)
    return TSlotNumber_from_obj({SlotNumber = SlotNumber})
end
---@param obj MLswSwitchInfo.SlotNumber
function TSlotNumber:init_from_obj(obj)
    self.SlotNumber = obj.SlotNumber
end

function TSlotNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSlotNumber.group)
end

TSlotNumber.from_obj = TSlotNumber_from_obj

TSlotNumber.proto_property = {'SlotNumber'}

TSlotNumber.default = {0}

TSlotNumber.struct = {{name = 'SlotNumber', is_array = false, struct = nil}}

function TSlotNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SlotNumber', self.SlotNumber, 'uint8', false, errs, need_convert)

    TSlotNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSlotNumber.proto_property, errs, need_convert)
    return self
end

function TSlotNumber:unpack(_)
    return self.SlotNumber
end

MLswSwitchInfo.SlotNumber = TSlotNumber

---@class MLswSwitchInfo.HealthState
---@field HealthState integer
local THealthState = {}
THealthState.__index = THealthState
THealthState.group = {}

local function THealthState_from_obj(obj)
    return setmetatable(obj, THealthState)
end

function THealthState.new(HealthState)
    return THealthState_from_obj({HealthState = HealthState})
end
---@param obj MLswSwitchInfo.HealthState
function THealthState:init_from_obj(obj)
    self.HealthState = obj.HealthState
end

function THealthState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THealthState.group)
end

THealthState.from_obj = THealthState_from_obj

THealthState.proto_property = {'HealthState'}

THealthState.default = {0}

THealthState.struct = {{name = 'HealthState', is_array = false, struct = nil}}

function THealthState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'HealthState', self.HealthState, 'uint8', false, errs, need_convert)

    THealthState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THealthState.proto_property, errs, need_convert)
    return self
end

function THealthState:unpack(_)
    return self.HealthState
end

MLswSwitchInfo.HealthState = THealthState

---@class MLswSwitchInfo.ErrorCode
---@field ErrorCode integer
local TErrorCode = {}
TErrorCode.__index = TErrorCode
TErrorCode.group = {}

local function TErrorCode_from_obj(obj)
    return setmetatable(obj, TErrorCode)
end

function TErrorCode.new(ErrorCode)
    return TErrorCode_from_obj({ErrorCode = ErrorCode})
end
---@param obj MLswSwitchInfo.ErrorCode
function TErrorCode:init_from_obj(obj)
    self.ErrorCode = obj.ErrorCode
end

function TErrorCode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TErrorCode.group)
end

TErrorCode.from_obj = TErrorCode_from_obj

TErrorCode.proto_property = {'ErrorCode'}

TErrorCode.default = {0}

TErrorCode.struct = {{name = 'ErrorCode', is_array = false, struct = nil}}

function TErrorCode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ErrorCode', self.ErrorCode, 'uint8', false, errs, need_convert)

    TErrorCode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TErrorCode.proto_property, errs, need_convert)
    return self
end

function TErrorCode:unpack(_)
    return self.ErrorCode
end

MLswSwitchInfo.ErrorCode = TErrorCode

---@class MLswSwitchInfo.PowerState
---@field PowerState integer
local TPowerState = {}
TPowerState.__index = TPowerState
TPowerState.group = {}

local function TPowerState_from_obj(obj)
    return setmetatable(obj, TPowerState)
end

function TPowerState.new(PowerState)
    return TPowerState_from_obj({PowerState = PowerState})
end
---@param obj MLswSwitchInfo.PowerState
function TPowerState:init_from_obj(obj)
    self.PowerState = obj.PowerState
end

function TPowerState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerState.group)
end

TPowerState.from_obj = TPowerState_from_obj

TPowerState.proto_property = {'PowerState'}

TPowerState.default = {0}

TPowerState.struct = {{name = 'PowerState', is_array = false, struct = nil}}

function TPowerState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerState', self.PowerState, 'uint8', false, errs, need_convert)

    TPowerState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerState.proto_property, errs, need_convert)
    return self
end

function TPowerState:unpack(_)
    return self.PowerState
end

MLswSwitchInfo.PowerState = TPowerState

---@class MLswSwitchInfo.ChipRst
---@field ChipRst integer
local TChipRst = {}
TChipRst.__index = TChipRst
TChipRst.group = {}

local function TChipRst_from_obj(obj)
    return setmetatable(obj, TChipRst)
end

function TChipRst.new(ChipRst)
    return TChipRst_from_obj({ChipRst = ChipRst})
end
---@param obj MLswSwitchInfo.ChipRst
function TChipRst:init_from_obj(obj)
    self.ChipRst = obj.ChipRst
end

function TChipRst:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChipRst.group)
end

TChipRst.from_obj = TChipRst_from_obj

TChipRst.proto_property = {'ChipRst'}

TChipRst.default = {0}

TChipRst.struct = {{name = 'ChipRst', is_array = false, struct = nil}}

function TChipRst:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ChipRst', self.ChipRst, 'uint8', false, errs, need_convert)

    TChipRst:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChipRst.proto_property, errs, need_convert)
    return self
end

function TChipRst:unpack(_)
    return self.ChipRst
end

MLswSwitchInfo.ChipRst = TChipRst

---@class MLswSwitchInfo.Type
---@field Type integer
local TType = {}
TType.__index = TType
TType.group = {}

local function TType_from_obj(obj)
    return setmetatable(obj, TType)
end

function TType.new(Type)
    return TType_from_obj({Type = Type})
end
---@param obj MLswSwitchInfo.Type
function TType:init_from_obj(obj)
    self.Type = obj.Type
end

function TType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TType.group)
end

TType.from_obj = TType_from_obj

TType.proto_property = {'Type'}

TType.default = {0}

TType.struct = {{name = 'Type', is_array = false, struct = nil}}

function TType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Type', self.Type, 'uint32', false, errs, need_convert)

    TType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TType.proto_property, errs, need_convert)
    return self
end

function TType:unpack(_)
    return self.Type
end

MLswSwitchInfo.Type = TType

---@class MLswSwitchInfo.Unit
---@field Unit integer
local TUnit = {}
TUnit.__index = TUnit
TUnit.group = {}

local function TUnit_from_obj(obj)
    return setmetatable(obj, TUnit)
end

function TUnit.new(Unit)
    return TUnit_from_obj({Unit = Unit})
end
---@param obj MLswSwitchInfo.Unit
function TUnit:init_from_obj(obj)
    self.Unit = obj.Unit
end

function TUnit:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUnit.group)
end

TUnit.from_obj = TUnit_from_obj

TUnit.proto_property = {'Unit'}

TUnit.default = {0}

TUnit.struct = {{name = 'Unit', is_array = false, struct = nil}}

function TUnit:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Unit', self.Unit, 'uint32', false, errs, need_convert)

    TUnit:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUnit.proto_property, errs, need_convert)
    return self
end

function TUnit:unpack(_)
    return self.Unit
end

MLswSwitchInfo.Unit = TUnit

return MLswSwitchInfo
