-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MLswPhyInfo = {}

---@class MLswPhyInfo.SlotNumber
---@field SlotNumber integer
local TSlotNumber = {}
TSlotNumber.__index = TSlotNumber
TSlotNumber.group = {}

local function TSlotNumber_from_obj(obj)
    return setmetatable(obj, TSlotNumber)
end

function TSlotNumber.new(SlotNumber)
    return TSlotNumber_from_obj({SlotNumber = SlotNumber})
end
---@param obj MLswPhyInfo.SlotNumber
function TSlotNumber:init_from_obj(obj)
    self.SlotNumber = obj.SlotNumber
end

function TSlotNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSlotNumber.group)
end

TSlotNumber.from_obj = TSlotNumber_from_obj

TSlotNumber.proto_property = {'SlotNumber'}

TSlotNumber.default = {0}

TSlotNumber.struct = {{name = 'SlotNumber', is_array = false, struct = nil}}

function TSlotNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SlotNumber', self.SlotNumber, 'uint8', false, errs, need_convert)

    TSlotNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSlotNumber.proto_property, errs, need_convert)
    return self
end

function TSlotNumber:unpack(_)
    return self.SlotNumber
end

MLswPhyInfo.SlotNumber = TSlotNumber

---@class MLswPhyInfo.HealthState
---@field HealthState integer
local THealthState = {}
THealthState.__index = THealthState
THealthState.group = {}

local function THealthState_from_obj(obj)
    return setmetatable(obj, THealthState)
end

function THealthState.new(HealthState)
    return THealthState_from_obj({HealthState = HealthState})
end
---@param obj MLswPhyInfo.HealthState
function THealthState:init_from_obj(obj)
    self.HealthState = obj.HealthState
end

function THealthState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THealthState.group)
end

THealthState.from_obj = THealthState_from_obj

THealthState.proto_property = {'HealthState'}

THealthState.default = {0}

THealthState.struct = {{name = 'HealthState', is_array = false, struct = nil}}

function THealthState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'HealthState', self.HealthState, 'uint8', false, errs, need_convert)

    THealthState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THealthState.proto_property, errs, need_convert)
    return self
end

function THealthState:unpack(_)
    return self.HealthState
end

MLswPhyInfo.HealthState = THealthState

---@class MLswPhyInfo.PowerState
---@field PowerState integer
local TPowerState = {}
TPowerState.__index = TPowerState
TPowerState.group = {}

local function TPowerState_from_obj(obj)
    return setmetatable(obj, TPowerState)
end

function TPowerState.new(PowerState)
    return TPowerState_from_obj({PowerState = PowerState})
end
---@param obj MLswPhyInfo.PowerState
function TPowerState:init_from_obj(obj)
    self.PowerState = obj.PowerState
end

function TPowerState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerState.group)
end

TPowerState.from_obj = TPowerState_from_obj

TPowerState.proto_property = {'PowerState'}

TPowerState.default = {0}

TPowerState.struct = {{name = 'PowerState', is_array = false, struct = nil}}

function TPowerState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerState', self.PowerState, 'uint8', false, errs, need_convert)

    TPowerState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerState.proto_property, errs, need_convert)
    return self
end

function TPowerState:unpack(_)
    return self.PowerState
end

MLswPhyInfo.PowerState = TPowerState

---@class MLswPhyInfo.CfgType
---@field CfgType integer
local TCfgType = {}
TCfgType.__index = TCfgType
TCfgType.group = {}

local function TCfgType_from_obj(obj)
    return setmetatable(obj, TCfgType)
end

function TCfgType.new(CfgType)
    return TCfgType_from_obj({CfgType = CfgType})
end
---@param obj MLswPhyInfo.CfgType
function TCfgType:init_from_obj(obj)
    self.CfgType = obj.CfgType
end

function TCfgType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCfgType.group)
end

TCfgType.from_obj = TCfgType_from_obj

TCfgType.proto_property = {'CfgType'}

TCfgType.default = {0}

TCfgType.struct = {{name = 'CfgType', is_array = false, struct = nil}}

function TCfgType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CfgType', self.CfgType, 'uint8', false, errs, need_convert)

    TCfgType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCfgType.proto_property, errs, need_convert)
    return self
end

function TCfgType:unpack(_)
    return self.CfgType
end

MLswPhyInfo.CfgType = TCfgType

---@class MLswPhyInfo.ChipRst
---@field ChipRst integer
local TChipRst = {}
TChipRst.__index = TChipRst
TChipRst.group = {}

local function TChipRst_from_obj(obj)
    return setmetatable(obj, TChipRst)
end

function TChipRst.new(ChipRst)
    return TChipRst_from_obj({ChipRst = ChipRst})
end
---@param obj MLswPhyInfo.ChipRst
function TChipRst:init_from_obj(obj)
    self.ChipRst = obj.ChipRst
end

function TChipRst:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChipRst.group)
end

TChipRst.from_obj = TChipRst_from_obj

TChipRst.proto_property = {'ChipRst'}

TChipRst.default = {0}

TChipRst.struct = {{name = 'ChipRst', is_array = false, struct = nil}}

function TChipRst:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ChipRst', self.ChipRst, 'uint8', false, errs, need_convert)

    TChipRst:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChipRst.proto_property, errs, need_convert)
    return self
end

function TChipRst:unpack(_)
    return self.ChipRst
end

MLswPhyInfo.ChipRst = TChipRst

---@class MLswPhyInfo.PhysicalAddr
---@field PhysicalAddr integer
local TPhysicalAddr = {}
TPhysicalAddr.__index = TPhysicalAddr
TPhysicalAddr.group = {}

local function TPhysicalAddr_from_obj(obj)
    return setmetatable(obj, TPhysicalAddr)
end

function TPhysicalAddr.new(PhysicalAddr)
    return TPhysicalAddr_from_obj({PhysicalAddr = PhysicalAddr})
end
---@param obj MLswPhyInfo.PhysicalAddr
function TPhysicalAddr:init_from_obj(obj)
    self.PhysicalAddr = obj.PhysicalAddr
end

function TPhysicalAddr:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPhysicalAddr.group)
end

TPhysicalAddr.from_obj = TPhysicalAddr_from_obj

TPhysicalAddr.proto_property = {'PhysicalAddr'}

TPhysicalAddr.default = {0}

TPhysicalAddr.struct = {{name = 'PhysicalAddr', is_array = false, struct = nil}}

function TPhysicalAddr:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PhysicalAddr', self.PhysicalAddr, 'uint8', false, errs, need_convert)

    TPhysicalAddr:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPhysicalAddr.proto_property, errs, need_convert)
    return self
end

function TPhysicalAddr:unpack(_)
    return self.PhysicalAddr
end

MLswPhyInfo.PhysicalAddr = TPhysicalAddr

---@class MLswPhyInfo.PhysicalId
---@field PhysicalId integer
local TPhysicalId = {}
TPhysicalId.__index = TPhysicalId
TPhysicalId.group = {}

local function TPhysicalId_from_obj(obj)
    return setmetatable(obj, TPhysicalId)
end

function TPhysicalId.new(PhysicalId)
    return TPhysicalId_from_obj({PhysicalId = PhysicalId})
end
---@param obj MLswPhyInfo.PhysicalId
function TPhysicalId:init_from_obj(obj)
    self.PhysicalId = obj.PhysicalId
end

function TPhysicalId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPhysicalId.group)
end

TPhysicalId.from_obj = TPhysicalId_from_obj

TPhysicalId.proto_property = {'PhysicalId'}

TPhysicalId.default = {0}

TPhysicalId.struct = {{name = 'PhysicalId', is_array = false, struct = nil}}

function TPhysicalId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PhysicalId', self.PhysicalId, 'uint32', false, errs, need_convert)

    TPhysicalId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPhysicalId.proto_property, errs, need_convert)
    return self
end

function TPhysicalId:unpack(_)
    return self.PhysicalId
end

MLswPhyInfo.PhysicalId = TPhysicalId

---@class MLswPhyInfo.Unit
---@field Unit integer
local TUnit = {}
TUnit.__index = TUnit
TUnit.group = {}

local function TUnit_from_obj(obj)
    return setmetatable(obj, TUnit)
end

function TUnit.new(Unit)
    return TUnit_from_obj({Unit = Unit})
end
---@param obj MLswPhyInfo.Unit
function TUnit:init_from_obj(obj)
    self.Unit = obj.Unit
end

function TUnit:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUnit.group)
end

TUnit.from_obj = TUnit_from_obj

TUnit.proto_property = {'Unit'}

TUnit.default = {0}

TUnit.struct = {{name = 'Unit', is_array = false, struct = nil}}

function TUnit:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Unit', self.Unit, 'uint32', false, errs, need_convert)

    TUnit:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUnit.proto_property, errs, need_convert)
    return self
end

function TUnit:unpack(_)
    return self.Unit
end

MLswPhyInfo.Unit = TUnit

return MLswPhyInfo
