-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MLswInfo = {}

---@class MLswInfo.IsCfg
---@field IsCfg boolean
local TIsCfg = {}
TIsCfg.__index = TIsCfg
TIsCfg.group = {}

local function TIsCfg_from_obj(obj)
    return setmetatable(obj, TIsCfg)
end

function TIsCfg.new(IsCfg)
    return TIsCfg_from_obj({IsCfg = IsCfg or false})
end
---@param obj MLswInfo.IsCfg
function TIsCfg:init_from_obj(obj)
    self.IsCfg = obj.IsCfg or false
end

function TIsCfg:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIsCfg.group)
end

TIsCfg.from_obj = TIsCfg_from_obj

TIsCfg.proto_property = {'IsCfg'}

TIsCfg.default = {false}

TIsCfg.struct = {{name = 'IsCfg', is_array = false, struct = nil}}

function TIsCfg:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'IsCfg', self.IsCfg, 'bool', false, errs, need_convert)

    TIsCfg:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIsCfg.proto_property, errs, need_convert)
    return self
end

function TIsCfg:unpack(_)
    return self.IsCfg
end

MLswInfo.IsCfg = TIsCfg

---@class MLswInfo.Unit
---@field Unit integer
local TUnit = {}
TUnit.__index = TUnit
TUnit.group = {}

local function TUnit_from_obj(obj)
    return setmetatable(obj, TUnit)
end

function TUnit.new(Unit)
    return TUnit_from_obj({Unit = Unit})
end
---@param obj MLswInfo.Unit
function TUnit:init_from_obj(obj)
    self.Unit = obj.Unit
end

function TUnit:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUnit.group)
end

TUnit.from_obj = TUnit_from_obj

TUnit.proto_property = {'Unit'}

TUnit.default = {0}

TUnit.struct = {{name = 'Unit', is_array = false, struct = nil}}

function TUnit:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Unit', self.Unit, 'uint32', false, errs, need_convert)

    TUnit:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUnit.proto_property, errs, need_convert)
    return self
end

function TUnit:unpack(_)
    return self.Unit
end

MLswInfo.Unit = TUnit

return MLswInfo
