# lsw

## 功能简介
lsw组件仓主要用于计算节点板中lsw交换板的网络配置，基于双平面网络实现对内/对外通信功能。

### 目录结构
```
├── luaclib                                              -- c代码
│   ├── CMakeLists.txt                                   -- c代码构建配置
│   ├── chip_dev.c                                       -- 芯片驱动
│   ├── chip_dev.h                                       -- 芯片驱动头文件
│   ├── gpio_driver.h                                    -- gpio驱动头文件
│   ├── lsw_drv.c                                        -- lua和c交互接口
│   ├── mdio_driver.c                                    -- mdio驱动
│   ├── mdio_driver.h                                    -- mdio驱动头文件
│   ├── phy_dev.c                                        -- phy驱动
│   ├── phy_dev.h                                        -- phy驱动头文件
│   ├── port_dev.c                                       -- port驱动
│   ├── port_dev.h                                       -- port驱动头文件
│   ├── rtk_type.h                                       -- rtk驱动头文件
│   ├── rtl8367_api.h                                    -- 芯片驱动接口
│   ├── rtl8367_type.h                                   -- 芯片类型定义
│   ├── vlan_dev.c                                       -- vlan驱动
│   └── vlan_dev.h                                       -- vlan驱动头文件
├── lualib                                               -- lua代码
│   ├── alarm
│   │   └── alarm.lua                                    -- 告警处理逻辑
│   ├── domain
│   │   ├── debug
│   │   │   ├── debug.lua                                -- debug方法，lsw配置及查询接口
│   │   │   └── monitor.lua                              -- 监控状态方法
│   │   ├── defs.lua                                     -- 固件定义信息文件
│   │   ├── device
│   │   │   ├── switch
│   │   │   │   ├── chip
│   │   │   │   │   ├── external_vlan.lua                -- 外网vlan配置
│   │   │   │   │   ├── port.lua                         -- lsw端口配置
│   │   │   │   │   ├── switch_chip.lua                  -- lsw chip芯片配置（8367/2507）
│   │   │   │   │   └── vlan.lua                         -- vlan配置（内网）
│   │   │   │   ├── component.lua
│   │   │   │   ├── phy
│   │   │   │   │   ├── phy.lua                          -- phy芯片配置（8211/8521）
│   │   │   │   │   └── phy_chip.lua
│   │   │   │   └── switch.lua                           -- lsw配置入口
│   │   │   └── switch_mgt.lua                           -- 注册对象分发回调函数
│   │   └── drv
│   ├── infrastructure
│   │   └── event.lua
│   ├── interface
│   │   └── rpc.lua                                      -- rpc方法
│   ├── lsw_app.lua
│   └── service
│       └── ipmi_service.lua
└── service
    └── main.lua                                         -- app入口
```

## 关键特性

### 整体架构设计
机柜内置网片提供框内/对外通信功能:
- 内部组网采用独立双平面方式，对外采用管理板集中出线方式
- 管理板与计算节点按照应用场景分为HPC与AI两种形态，硬件实现存在差异，软件采用归一化设计

组网应用中，外部组网采用3层交换网络，因此
- 管理板对外对接3层网络（HPC场景为2层，AI场景为3层）
- 内部通信为2层网络。无框间级联场景

不同场景下采取的方案
- 管理板：双平面双MAC + 近端运维MGMT网口；
- HPC节点板：双平面双MAC；
- AI节点版本：单平面单MAC; 内部通信场景，通过增加vlan方式，补充为双平面，实现方案归一。

### 框内通信
通过VLAN划分内外网，同时从可靠性考虑，2个平面同时可用

管理板：
- 2个SGMII网口分别配置不同VLAN;
 
计算节点：
- HPC节点板，2个SGMII网口分别配置不同VLAN；
- AI节点板，BMC在同1个SGMII网口配置2个VLAN ；
- AI节点板，LSW配置2个VLAN可以同时转发；
- BMC复位场景，LSW不能跟随复位，不能影响1260与管理板1213之间的通信。

管理交换板lsw/phy芯片驱动,支持完成lsw、phy芯片网络配置

### 故障检测/自愈
- lsw支持检测lsw、phy芯片配置异常检测，检测到配置状态异常时触发自愈
- 若连续自愈失败，网络状态异常，触发lsw/phy链路异常告警
- 支持上报故障码，用于查看网络配置状态

## 对外接口
### 资源树接口

- LanSwitchMock
    - Path: `/bmc/kepler/Debug/LanSwitchMock` 
    - Interface: `bmc.kepler.Debug.LanSwitchMock`

        | 方法  | 描述  |
        | :------------: | :------------: |
        | GetPortInfo | 获取端口信息 |
        | SetPortEnable | 设置端口使能状态 |
        | SetPortStpState | 设置stp状态 |
        | GetSwitchErrorCode | 获取lsw错误码 |
        | SetPortMacAddr | 设置端口Mac地址 |
        | FlushPortAddr | 清除端口地址信息 |
        | GetVlanInfo | 获取Vlan信息 |
        | RegRead | 读寄存器值 |
        | RegWrite | 写寄存器值 |
- LanSwitch
    - Path: `/bmc/kepler/Chassis/:ChassisId/LanSwitchs/:Id` 
    - Interface: `bmc.kepler.Chassis.LanSwitch`

        | 方法  | 描述  |
        | :------------: | :------------: |
        | LswReset | 复位lsw |
        | GetConfigInfo | 获取lsw配置信息 |


### IPMI命令
- 具体参数参考本组件配置文件`ipmi.json`

| 方法  | 描述  |
| :------------: | :------------: |
| GetPortLinkStatus | 获取端口连接状态 |
| GetPortSpeed | 获取端口速率 |

## 配置介绍

### LSW网络配置
#### 框内（内部通信）场景

| 场景  | 单板类型  | VLAN | 描述 |
| :------------: | :------------: | :------------: | :------------: |
| 框内设备管理 | 管理板/计算节点 | 4090 | 限于框内通性，SMM和BMC/BMC和BMC之间通信 |
| 框内设备管理 | 管理板/计算节点 | 4091 | 限于框内通性，SMM和BMC/BMC和BMC之间通信 |

BMC在同1个SGMII网口配置2个VLAN（4090、4091）
LSW配置2个VLAN可以同时转发（port 0配置4090、4091，port 2配置4091，port 3配置4092）
BMC复位场景，LSW不能跟随复位，不能影响1260与管理板1213之间的通信

![image](https://wiki.huawei.com/vision-file-storage/api/file/download/upload-v2/WIKI202406193807493/9127099/image.png)

#### 网管对接/远程运维/近端运维场景

| 场景  | 单板类型  | VLAN | 描述 |
| :------------: | :------------: | :------------: | :------------: |
| 网管对接/远程运维 | 计算节点 | 1 | 单IP，BMC与外部网管通信 |
| 网管对接/远程运维 | 管理板 | 1 | 浮动IP，SMM与外部网管通信 |
| 网管对接/远程运维 | 管理板 | 1 | 静态IP，SMM与外部网管通信（浮动IP不可用时，预留逃生通道，按需配置 |
| 近端运维 | 管理板 | 1 | 单IP，近端运维使用（按需配置） |

LSW配置：对port0、port2、port3配置pvid为1

![image](https://wiki.huawei.com/vision-file-storage/api/file/download/upload-v2/WIKI202406193807493/9202683/image.png)

#### 主备倒换场景

| 场景  | 单板类型  | VLAN | 描述 |
| :------------: | :------------: | :------------: | :------------: |
| 主备倒换 | 计算节点 | 1 | 1、单IP，跟随主用单板切换2、切换后触发外部交换机表项刷新 |
| 主备倒换 | 管理板 | 1 | 1、浮动IP，跟随主用单板切换2、切换后触发外部交换机表项刷新 |

主备管理：
1. 软件通过发送心跳来确认本板软件的正常运行状态
2. 两块SMM谁先发送心跳,谁就先抢到主
3. 创建一个主备管理任务，定时发送软心跳，并根据硬件主备状态寄存器值来实现主备状态迁移管理

平台子系统发送主备切换信号，lsw监听到信号后配置对相应通路端口配置外网vlan（默认1）

#### lsw网络配置流程

lsw网络配置主要包含以下几个步骤：
1. chip（Realtek rtl8367 / Huyang sf2507）初始化
2. port（port0 - port4）初始化
3. phy（8211 / 8521）初始化
4. 配置vlan（4090、4091）

配置过程如下：
- 配置csr
- 自发现分发对象
- 创建管理对象并添加相应对象
- 进行初始化，并配置相关信息

流程图如下：
![image](https://wiki.huawei.com/vision-file-storage/api/file/download/upload-v2/WIKI202406193810972/11842560/2009dbac1d004985a92c27b868f91367.png)