-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local lu = require 'luaunit'
local utils = require 'mc.utils'
local m_enums = require 'syssdm.types.enums'
local f_dbconn = require 'syssdm.db'
local m_dataset = require 'syssdm.datas'
local c_realtimecmd = require 'cmd_service.realtime_command'

TestRealtimeCommand = {}

function TestRealtimeCommand:setUp()
    utils.remove_file('./syssdm.test.db')
    self.db = f_dbconn('./syssdm.test.db', m_dataset)
end

function TestRealtimeCommand:tearDown()
    utils.remove_file('./syssdm.test.db')
end

function TestRealtimeCommand:test_set_args()
    local obj = c_realtimecmd.new()
    obj:set_args(nil, '/bmc/kepler/Syssdm', 'bmc.kepler.Syssdm', 'PowerCtrlSignal', 'iiii', 1, 0,
                        m_enums.PowerCtrlType.On, m_enums.RestartCause.ChassisControlCommand)
    lu.assertEquals(obj.path, '/bmc/kepler/Syssdm')
    lu.assertEquals(obj.interface, 'bmc.kepler.Syssdm')
    lu.assertEquals(obj.signal, 'PowerCtrlSignal')
    lu.assertEquals(obj.args_tbl,
                    {1, 0, m_enums.PowerCtrlType.On, m_enums.RestartCause.ChassisControlCommand})
end

function TestRealtimeCommand:test_send_command()
  local obj = c_realtimecmd.new()
  local ret = obj:send_command()
  lu.assertEquals(ret, -1)
end
