-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local skynet = require 'skynet'
require 'skynet.manager'
local log = require 'mc.logging'
local bmc_app = require 'syssdm_app'

local app = nil
local CMD = {}

function CMD.exit()
  log:info('syssdm service exit')
end

skynet.start(function()
  skynet.register('syssdm')
  app = bmc_app.new()
  skynet.dispatch('lua', function(_, _, cmd, ...)
    local f = assert(CMD[cmd])
    skynet.ret(skynet.pack(f(...)))
  end)
end)
