-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local json = require 'cjson'
local log = require 'mc.logging'
local class = require 'mc.class'
-- local sd_bus = require 'sd_bus'
local c_command = require 'cmd_service.command'

-- realtime command strategy
local crealtime_command = class(c_command)

function crealtime_command:ctor(...)
    log:debug('crealtime_command constructor')
end

function crealtime_command:set_args(bus, object_path, interface_name, signal_name, signal_signature, ...)
    log:debug('set real-time command args')
    self.bus = bus
    self.path = object_path
    self.interface = interface_name
    self.signal = signal_name
    self.signal_signature = signal_signature
    -- local tmp = {}
    -- for i = 1, select("#", ...) do
    --     tmp[i] = select(i, ...)
    -- end
    self.args_tbl = {...}
end

function crealtime_command:send_command()
    if self.bus == nil then
        log:error('bus is nil')
        return -1
    end

    log:info('send real-time command: object path %s, interface %s, signal %s, signature %s, args %s',
             self.path, self.interface, self.signal, self.signal_signature, json.encode(self.args_tbl))

    self.bus:signal(self.path, self.interface, self.signal, self.signal_signature, table.unpack(self.args_tbl))
    return 0
end

return crealtime_command
