-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local class = require 'mc.class'
local log = require 'mc.logging'

-- abstract class 
local ccommand = class()

function ccommand:ctor(...)
    log:debug('this is abstract class, constuctor do nothing')
end

function ccommand:set_args(...)
    log:debug('this is abstract class, virtual function do nothing')
end

function ccommand:send()
    if self.send_command then
        return self:send_command()
    end
    error('not implemented function: send_command()')
end

return ccommand
