-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local bs = require 'mc.bitstring'
local utils = require 'mc.utils'
local lu = require 'luaunit'
local log = require 'mc.logging'
local vrd_object = require 'vrd.vrd_object'
local ipmi = require 'ipmi'
local enums = require 'ipmi.enums'
local vrd_enums = require 'vrd.enum.vrd_enums'

local channel_type = enums.ChannelType
local comp_code = ipmi.types.Cc

TestVrdManager = {}

function TestVrdManager:test_parse_vrd_rsp_info()
    local payload = '\x00\x07\xDB' .. '\x01' .. -- CpuId
    '\x02\x09' .. -- PowerNum和InfoSize
    '\x00\x00' .. -- type和dieid
    '\x02\x03' .. -- 电压
    '\x04\x05\x06' .. -- 电流
    '\x07\x08' .. -- 温度
    '\x01\x02' .. -- type和dieid
    '\x05\x03' .. -- 电压
    '\x04\x05\x06' .. -- 电流
    '\x02\x06' -- 温度

    local obj = vrd_object.new()
    local cc = obj:parse_vrd_rsp_info(payload)
    assert(cc == comp_code.Success)

    payload = '\x00\x07\xDB' .. '\x01' .. -- CpuId
    '\x03\x09' .. -- PowerNum和InfoSize
    '\x00\x00' .. -- type和dieid
    '\x02\x03' .. -- 电压
    '\x04\x05\x06' .. -- 电流
    '\x07\x08' .. -- 温度
    '\x01\x02' .. -- type和dieid
    '\x05\x03' .. -- 电压
    '\x04\x05\x06' .. -- 电流
    '\x02\x06' .. -- 温度
    '\x02\x00' --   type和dieid

    cc = obj:parse_vrd_rsp_info(payload)
    assert(cc == comp_code.ResponseError)

end

function TestVrdManager:test_parse_with_real_data()
    local payload = table.concat({
        '\x00\x07\xDB\x00\x07\x09\x00\x01\x64\x01\xFF\xFF\xFF\xB4\x0C\x00',
        '\x03\x64\x01\xFF\xFF\xFF\xB4\x0C\x01\xFF\x64\x01\xFF\xFF\xFF\xB4',
        '\x0C\x02\xFF\x64\x01\xFF\xFF\xFF\xB4\x0C\x03\x00\x64\x01\xFF\xFF',
        '\xFF\xB4\x0C\x03\x02\x64\x01\xFF\xFF\xFF\xB4\x0C\x04\xFF\x64\x01', '\xFF\xFF\xFF\xB4\x0C'
    })

    local obj = vrd_object.new()
    local cc = obj:parse_vrd_rsp_info(payload)
    assert(cc == comp_code.Success)

    local payload = table.concat({
        '\x00\x07\xDB\x01\x07\x09\x00\x01\x64\x01\xF4\x00\x00\xB4\x0C\x00',
        '\x03\x64\x01\xF4\x00\x00\xB4\x0C\x01\xFF\x64\x01\xF4\x00\x00\xB4',
        '\x0C\x02\xFF\x64\x01\xF4\x00\x00\xB4\x0C\x03\x00\x64\x01\xF4\x00',
        '\x00\xB4\x0C\x03\x02\x64\x01\xF4\x00\x00\xB4\x0C\x04\xFF\x64\x01', '\xF4\x00\x00\xB4\x0C'
    })
    local cc = obj:parse_vrd_rsp_info(payload)
    assert(cc == comp_code.Success)
end
