-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local agent = require 'retimer.agent.retimer_agent_M88RT51632'
local PARAMETERS = require 'retimer.agent.retimer_agent_M88RT51632_utils'
local class = require 'mc.class'

local smbus = class()

function smbus:ctor(retimer_write)
    self.retimer_write = retimer_write
end

function smbus:retimer_read(args)
    if args.addr == 0x104c then
        return true, 0x068EB006
    end
    if args.addr == 0xa18 then
        return true, 0x490410
    end
    if args.addr == 0xb18 then
        return true, 0x470460
    end
    return true, 0xffffffff
end

function smbus:retimer_loop_read(args)

    if args.addr == 0xa18 then
        return true, 0x490410
    end
    if args.addr == 0xb18 then
        return true, 0x470460
    end
    return true, 0xffffffff
end

TestRetimerAgent = {}

function TestRetimerAgent:test_get_power_status()
    local retimer = {name = "retimer", retimer_obj = {}}
    local s = agent.new(retimer, "bus_id")
    local status = s:get_power_status(1)
    lu.assertEquals(status, nil)
end

function TestRetimerAgent:test_can_create_smbus_M88RT51632()
    local retimer = {name = "retimer", retimer_obj = {}}
    local s = agent.new(retimer, "bus_id")
    lu.assertEquals(s.name, "retimer")
    lu.assertEquals(s.bus, "bus_id")
end

function TestRetimerAgent:test_update_retimer_info()
    local retimer = {
        name = "retimer",
        retimer_obj = {
            RefChip = {},
            ["FirmwareVersion"] = "",
            ["TemperatureCelsius"] = 0
        },
        update_firmware_severity = function()
        end
    }
    local item = agent.new(retimer, "bus_id")
    item.protocol = smbus.new(function(...)
        return true, nil
    end)
    item:update_retimer_info(PARAMETERS.PARAMETERS_INHERENT)
    item:update_retimer_info(PARAMETERS.PARAMETERS_DYNAMIC)
    lu.assertEquals(item.retimer.retimer_obj["TemperatureCelsius"], 70)
    lu.assertEquals(item.retimer.retimer_obj["FirmwareVersion"], "06.8E.B0.06")
end

function TestRetimerAgent:test_process_update_info_fail()
    local retimer = {
        name = "retimer",
        retimer_obj = {
            RefChip = {},
            ["FirmwareVersion"] = "",
            ["TemperatureCelsius"] = 0
        }
    }
    local item = agent.new(retimer, "bus_id")
    item.protocol = smbus.new(function(...)
        return false, nil
    end)
    for i = 1,3 do
        item:update_retimer_info(PARAMETERS.PARAMETERS_DYNAMIC)
    end
    lu.assertEquals(item.hysteresis, 0)
    lu.assertEquals(item.retimer.retimer_obj["TemperatureCelsius"], 0)
end

function TestRetimerAgent:test_retimer_monitor_tasks()
    local retimer = {
        name = "retimer",
        retimer_obj = {
            RefChip = {},
            ["FirmwareVersion"] = "",
            ["TemperatureCelsius"] = 0
        },
        update_firmware_version = function(...)
        end,
        update_firmware_severity = function(...)
        end,        
    }
    local item = agent.new(retimer, "bus_id")
    item.protocol = smbus.new(function(...)
        return true, nil
    end)
    item.judge_retimer_ready = function(...)
        return true
    end
    lu.assertEquals(item.start_monitor_flag, false)
    item:retimer_power_on_task()
    lu.assertEquals(item.retimer.retimer_obj["FirmwareVersion"], "06.8E.B0.06")
    lu.assertEquals(item.start_monitor_flag, true)
    item:retimer_monitor_task()
    lu.assertEquals(item.retimer.retimer_obj["TemperatureCelsius"], 70)
    item.judge_retimer_ready = function(...)
        return false
    end
    item.start_monitor_flag = true
    item:retimer_power_off_task(PARAMETERS.DEFAULT_VALUE)
    lu.assertEquals(item.retimer.retimer_obj["TemperatureCelsius"], 0)

    item.start_monitor_flag = false
    item.update_retimer_info = function(...)
        return false
    end
    item:retimer_power_on_task()
    lu.assertEquals(item.retimer.retimer_obj["FirmwareVersion"], "06.8E.B0.06")
end