-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local npu_board = require 'unit_manager.class.unit.acu.npu_board'
local utils = require 'mc.utils'
local file_sec = require 'utils.file'
local lu = require 'luaunit'

TestNpu = {}

function TestNpu:test_npu_log()
    local ok = pcall(function ()
        return npu_board:on_dump_mcu_log_cb()
    end)
    lu.assertEquals(ok, false)
end

function TestNpu:test_npu_log2()
    local true_func = function(...)
        return 0
    end
    local false_func = function(...)
        return -1
    end

    local mkdir = utils.mkdir_with_parents
    local check_realpath = file_sec.check_realpath_before_open_s
    utils.mkdir_with_parents = true_func

    -- test on_dump_mcu_log_cb 行206
    file_sec.check_realpath_before_open_s = true_func
    npu_board.mds_obj = {
        DeviceName = 'test',
        Name = 'test'
    }
    local ok = pcall(function ()
        return npu_board:on_dump_mcu_log_cb()
    end)
    lu.assertEquals(ok, true)
    -- test on_dump_mcu_log_cb 行200
    file_sec.check_realpath_before_open_s = false_func
    local ok = pcall(function ()
        return npu_board:on_dump_mcu_log_cb()
    end)
    lu.assertEquals(ok, true)

    file_sec.check_realpath_before_open_s = check_realpath
    utils.mkdir_with_parents = mkdir
end
