-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local smc_interace = require 'mcu.upgrade.smc_interface'
local cmn = require 'common'

TestSmcInterface = {}

local INSYNC <const> = 2    -- 待升级MCU暂不能升级，有可能是在同步主备分区,返回2
local FAIL <const> = 3       -- MCU升级失败,返回3

local function stub_query_upgrade_status(state)
    smc_interace.query_upgrade_status = function ()
        return state
    end
end

-- 测试查询传输结果失败
function TestSmcInterface:test_get_next_frame_offset_not_support()
    stub_query_upgrade_status(INSYNC)
    local offset = 0
    local retrans = {retry_times = 0, last_2k_pos = 0, total_times = 0}
    local support_query = false
    local params_list = {delay = 1, subsection_size = 2304, smc_data_len = 96}
    _, retrans = smc_interace:get_next_frame_offset(offset, retrans, support_query, params_list)
    lu.assertEquals(retrans['retry_times'], 0)
end

local function stub_get_next_frame_offset_from_mcu()
    smc_interace.get_next_frame_offset_from_mcu = function (_, offset, retrans, _, _)
        return offset, retrans
    end
end

-- 测试发送数据成功
function TestSmcInterface:test_get_next_frame_offset_ok()
    stub_query_upgrade_status(INSYNC)
    stub_get_next_frame_offset_from_mcu()
    local offset = 0
    local retrans = {retry_times = 0, last_2k_pos = 0, total_times = 0}
    local support_query = true
    local params_list = {delay = 1, subsection_size = 2304, smc_data_len = 96}
    _, retrans = smc_interace:get_next_frame_offset(offset, retrans, support_query, params_list)
    lu.assertEquals(retrans['retry_times'], 0)
end

-- 测试发送数据失败
function TestSmcInterface:test_get_next_frame_offset_failed()
    cmn.skynet.sleep = function() end
    stub_query_upgrade_status(FAIL)
    local offset = 0
    local retrans = {retry_times = 0, last_2k_pos = 0, total_times = 0}
    local support_query = true
    local params_list = {delay = 1, subsection_size = 2304, smc_data_len = 96}
    _, retrans = smc_interace:get_next_frame_offset(offset, retrans, support_query, params_list)
    lu.assertEquals(retrans['retry_times'], 0)
end
