-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local lu = require 'luaunit'
local test_utils = require 'mc.utils'
local test_file_sec = require 'utils.file'
local test_main_service = require 'maintenance_service.maintenance_csr'
local client = require 'general_hardware.client'

TestMaintenance = {}

local connector_name = "Connextor_CLU_1_0101"
local file_path = 'test'
local ctx = {}
ctx.get_initiator = function()
    return {}
end

local import_task = test_main_service.import_csr_task
test_main_service.import_csr_task = function (...)
    return true
end

function TestMaintenance:TestImportPathFalse()
    test_main_service:init()
    local pre_fun = test_utils.realpath
    local pre_fun_name_s = test_utils.get_file_name_s
    test_utils.realpath = function ()
        return error("path is nil")
    end
    test_file_sec.get_file_name_s =function ()
        return 'real_path.txt'
    end
    local data_first_byte = test_main_service:import_csr(self.construct_ctx, connector_name, file_path)
    lu.assertEquals(data_first_byte, 1)
    test_utils.realpath = pre_fun
    test_utils.get_file_name_s = pre_fun_name_s
end

function TestMaintenance:TestImportPathTrue()
    test_main_service:init()
    local pre_fun = test_utils.realpath
    local pre_fun_name_s = test_utils.get_file_name_s
    local pre_fun_realpath_before = test_file_sec.check_realpath_before_open_s
    test_utils.realpath = function ()
        return '/tmp/real_path.txt'
    end
    test_file_sec.get_file_name_s =function ()
        return 'real_path.txt'
    end
    test_file_sec.check_realpath_before_open_s =function (...)
        return 0
    end

    local data_first_byte = test_main_service:import_csr(ctx, connector_name, file_path)
    lu.assertEquals(data_first_byte, 1)
    test_utils.realpath = pre_fun
    test_utils.get_file_name_s = pre_fun_name_s
    test_file_sec.check_realpath_before_open_s = pre_fun_realpath_before

end

function TestMaintenance:TestImportPathTrueflag()
    test_main_service:init()
    local pre_fun = test_utils.realpath
    local pre_fun_name_s = test_utils.get_file_name_s
    local pre_fun_realpath_before = test_file_sec.check_realpath_before_open_s
    test_utils.realpath = function ()
        return '/t/ok'
    end
    test_file_sec.get_file_name_s =function ()
        return 'path.txt'
    end
    test_file_sec.check_realpath_before_open_s =function (...)
        return 1
    end
    local data_first_byte = test_main_service:import_csr(ctx, connector_name, file_path)
    lu.assertEquals(data_first_byte, nil)
    test_utils.realpath = pre_fun
    test_utils.get_file_name_s = pre_fun_name_s
    test_file_sec.check_realpath_before_open_s = pre_fun_realpath_before
end

function TestMaintenance:TestProcessPackageInfo()
    test_main_service:init()
    local client_func = client.UpdateServiceUpdateServiceParseFirmwarePackage
    local check_shell = test_file_sec.check_shell_special_character_s
    test_file_sec.check_shell_special_character_s = function(...)
        return -1
    end
    client.UpdateServiceUpdateServiceParseFirmwarePackage = function(...)
        return {FirmwareDirectory = 'test'}
    end
    ok = pcall(import_task, test_main_service, ctx, nil, file_path, nil)
    lu.assertEquals(ok, true)
    client.UpdateServiceUpdateServiceParseFirmwarePackage = client_func
    test_file_sec.check_shell_special_character_s = check_shell
end

function TestMaintenance:TestRequireTraceFail()
    local pre_fun = test_main_service.init
    test_main_service.init = function(self)
        self.tracer = nil
    end
    test_main_service:init()
    local client_func = client.UpdateServiceUpdateServiceParseFirmwarePackage
    local check_shell = test_file_sec.check_shell_special_character_s
    test_file_sec.check_shell_special_character_s = function(...)
        return -1
    end
    client.UpdateServiceUpdateServiceParseFirmwarePackage = function(...)
        return {FirmwareDirectory = 'test'}
    end
    ok = pcall(import_task, test_main_service, ctx, nil, file_path, nil)
    lu.assertEquals(ok, true)
    client.UpdateServiceUpdateServiceParseFirmwarePackage = client_func
    test_file_sec.check_shell_special_character_s = check_shell
    test_main_service.init = pre_fun
end
