-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local vastai_gpu_object = require 'gpu_service.vastai_gpu_object'
local lu = require 'luaunit'
local bs = require 'mc.bitstring'

TestVastaiGpu = {}

local get_vastai_sn = vastai_gpu_object.get_vastai_sn
local get_vastai_power = vastai_gpu_object.get_vastai_power
local gpu = vastai_gpu_object.gpu
local change_vastai_info = vastai_gpu_object.change_vastai_info
local new = bs.new
local action_task = vastai_gpu_object.action_task

function TestVastaiGpu:setUp()

end

function TestVastaiGpu:teardown()
    vastai_gpu_object.get_vastai_sn = get_vastai_sn
    vastai_gpu_object.get_vastai_power = get_vastai_power
    vastai_gpu_object.gpu = gpu
    vastai_gpu_object.change_vastai_info = change_vastai_info
    bs.new = new
    vastai_gpu_object.action_task = action_task
end

function TestVastaiGpu:test_get_vastai_sn_failed()
    local chip = {
        Read = function (...)
            error()
        end
    }
    local sn = vastai_gpu_object.get_vastai_sn(vastai_gpu_object, chip)
    lu.assertEquals(sn, '')
end

function TestVastaiGpu:test_get_vastai_sn_verify_data_failed()
    local chip = {
        Read = function (...)
            return "AB"
        end
    }
    local sn = vastai_gpu_object.get_vastai_sn(vastai_gpu_object, chip)
    lu.assertEquals(sn, '')
end

function TestVastaiGpu:test_get_vastai_power_failed()
    local chip = {
        Read = function (...)
            error()
        end
    }
    local power = vastai_gpu_object.get_vastai_power(vastai_gpu_object, chip)
    lu.assertEquals(power, 0)
end

function TestVastaiGpu:test_get_vastai_power_verify_data_failed()
    local chip = {
        Read = function (...)
            return "AB"
        end
    }
    local power = vastai_gpu_object.get_vastai_power(vastai_gpu_object, chip)
    lu.assertEquals(power, 0)
end

function TestVastaiGpu:test_get_vastai_power_success()
    local chip = {
        Read = function (...)
            return "@@@?"
        end
    }
    bs.new = function (...)
        return {
            unpack = function (...)
                return {
                    power = 1000000
                }
            end
        }
    end
    local power = vastai_gpu_object.get_vastai_power(vastai_gpu_object, chip)
    lu.assertEquals(power, 1)
end

function TestVastaiGpu:test_start_action_task()
    vastai_gpu_object.change_vastai_info = function ()
        return
    end
    vastai_gpu_object.start_action_task(vastai_gpu_object)
end

function TestVastaiGpu:test_change_vastai_info_sn_failed()
    vastai_gpu_object.action_task = true
    vastai_gpu_object.gpu = {
        RefChip = nil
    }
    vastai_gpu_object.get_vastai_sn = function ()
        error()
    end
    local ok, _ = pcall(vastai_gpu_object.change_vastai_info, vastai_gpu_object)
    lu.assertEquals(ok, false)
end

function TestVastaiGpu:test_change_vastai_info_power_failed()
    vastai_gpu_object.action_task = true
    vastai_gpu_object.gpu = {
        RefChip = nil
    }
    vastai_gpu_object.get_vastai_sn = function ()
        return "sn"
    end
    vastai_gpu_object.get_vastai_power = function ()
        error()
    end
    local ok, _ = pcall(vastai_gpu_object.change_vastai_info, vastai_gpu_object)
    lu.assertEquals(ok, false)
end

function TestVastaiGpu:test_stop_action_task()
    vastai_gpu_object.stop_action_task(vastai_gpu_object)
    vastai_gpu_object.stop_action_task(vastai_gpu_object)
end