-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: 处理器资源集成测试用例
local lu = require "luaunit"
local log = require 'mc.logging'
local mdb = require 'mc.mdb'
local mdb_service = require 'mc.mdb.mdb_service'

local VRD_PATH<const> = "/bmc/kepler/Systems/1/Vrd/"
local VRD_INTERFACE<const> = "bmc.kepler.Systems.VrdMgmt"

require 'general_hardware.json_types.VrdMgmt'


local test_vrd = {}

local function get_vrd_obj_list(bus, path, interface)
    local rsp = mdb_service.get_sub_paths(bus,  path, 1, {interface})
    return rsp.SubPaths
end

local function test_sorce_on_tree(bus)
    local obj_list = get_vrd_obj_list(bus, VRD_PATH, VRD_INTERFACE)
    for _, path in pairs(obj_list) do
        local obj = mdb.get_object(bus, path, VRD_INTERFACE)
        lu.assertEquals(obj.SystemId, 1)
    end
end

function test_vrd.test_all_vrd_method(bus)
    test_sorce_on_tree(bus)
    log:info("- test vrd finish")
end

return test_vrd