-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: Retimer集成测试

local lu = require "luaunit"
local mdb_service = require 'mc.mdb.mdb_service'

local RETIMER_PATH = "/bmc/kepler/Systems/1/Retimers/"
local RETIMER_INTERFACE = "bmc.kepler.Systems.Retimer"

local test_retimer = {}

local function get_retimer_obj_list(bus, path, interface)
    local rsp = mdb_service.get_sub_paths(bus, path, 1, {interface})
    return rsp.SubPaths
end

local function test_retimer_on_tree(bus)
    local obj_list = get_retimer_obj_list(bus, RETIMER_PATH, RETIMER_INTERFACE)
    lu.assertEquals(#obj_list, 2)  -- 预置了2个Retimer对象
end

function test_retimer.test_retimer(bus)
    test_retimer_on_tree(bus)
end

return test_retimer