-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: 装备测试集成测试用例
local lu = require 'luaunit'
local log = require 'mc.logging'
local mdb = require 'mc.mdb'
local context = require'mc.context'

require 'general_hardware.json_types.Manufacture'
local test_memory = {}

local DFTMEMORYVLOT_PATH = '/bmc/kepler/Manufacture/SelfTest/DftMemoryVolt/DftMemoryVolt_1_010101'
local DFT12V0VLOT_PATH = '/bmc/kepler/Manufacture/SelfTest/Dft12V0Vlot/Dft12V0Vlot_1_010101'
local DFT5V0VLOT_PATH = '/bmc/kepler/Manufacture/SelfTest/Dft5V0Vlot/Dft5V0Vlot_1_010101'
local DFT3V3VLOT_PATH = '/bmc/kepler/Manufacture/SelfTest/Dft3V3Vlot/Dft3V3Vlot_1_010101'
local DFTCARDPRESENCE_PATH = '/bmc/kepler/Manufacture/SelfTest/DftCardPresence/DftCardPresence_1_010101'
local DFTBUTTONCELL_PATH = '/bmc/kepler/Manufacture/SelfTest/DftButtonCell/DftButtonCell_1_010101'
local DFTFLASH_PATH = '/bmc/kepler/Manufacture/SelfTest/DftFlash/DftFlash_1_010101'
local DFTCPLD_PATH = '/bmc/kepler/Manufacture/SelfTest/DftCpld/DftCpld_1_010101'
local DFTIOTEST_PATH = '/bmc/kepler/Manufacture/PrepareTest/DftIOTest/DftIOTest_1_010101'
local DFTHWCHANNEL_PATH = '/bmc/kepler/Manufacture/PrepareTest/DftHwChannel/DftHwChannel_010101'
local DFT_INTERFACE = 'bmc.kepler.Manufacture'

-- 测试装备项 Dft12V0Vlot
local function test_dft_12v0_vlot(bus)
    local obj = mdb.get_object(bus, DFT12V0VLOT_PATH, DFT_INTERFACE)
    lu.assertEquals(obj.Slot, 1)
    obj:Start_PACKED(context.new())
    lu.assertEquals(obj.Status, "Complete")
    local resp = obj:GetResult_PACKED(context.new())
    lu.assertEquals(resp.Status, "Failed")
    lu.assertEquals(resp.Description, "")
    log:notice('- test dft 12v0 vlot finish')
    obj:Stop_PACKED(context.new())
    lu.assertEquals(obj.Status, "Unstart")
end

-- 测试装备项 Dft5V0Vlot
local function test_dft_5v0_vlot(bus)
    local obj = mdb.get_object(bus, DFT5V0VLOT_PATH, DFT_INTERFACE)
    lu.assertEquals(obj.Slot, 1)
    obj:Start_PACKED(context.new())
    lu.assertEquals(obj.Status, "Complete")
    local resp = obj:GetResult_PACKED(context.new())
    lu.assertEquals(resp.Status, "Succeed")
    lu.assertEquals(resp.Description, "")
    log:notice('- test dft 5v0 vlot finish')
    obj:Stop_PACKED(context.new())
    lu.assertEquals(obj.Status, "Unstart")
end

-- 测试装备项 Dft3V3Vlot
local function test_dft_3v3_vlot(bus)
    local obj = mdb.get_object(bus, DFT3V3VLOT_PATH, DFT_INTERFACE)
    lu.assertEquals(obj.Slot, 1)
    obj:Start_PACKED(context.new())
    lu.assertEquals(obj.Status, "Complete")
    local resp = obj:GetResult_PACKED(context.new())
    lu.assertEquals(resp.Status, "Failed")
    lu.assertEquals(resp.Description, "")
    log:notice('- test dft 3v3 vlot finish')
    obj:Stop_PACKED(context.new())
    lu.assertEquals(obj.Status, "Unstart")
end

-- 测试装备项 DftCardPresence
local function test_dft_card_presence(bus)
    local obj = mdb.get_object(bus, DFTCARDPRESENCE_PATH, DFT_INTERFACE)
    lu.assertEquals(obj.Slot, 1)
    obj:Start_PACKED(context.new())
    lu.assertEquals(obj.Status, "Complete")
    local resp = obj:GetResult_PACKED(context.new())
    lu.assertEquals(resp.Status, "Succeed")
    lu.assertEquals(resp.Description, "")
    log:notice('- test dft card presence finish')
    obj:Stop_PACKED(context.new())
    lu.assertEquals(obj.Status, "Unstart")
end

-- 测试装备项 DftButtonCell
local function test_dft_button_cell(bus)
    local obj = mdb.get_object(bus, DFTBUTTONCELL_PATH, DFT_INTERFACE)
    lu.assertEquals(obj.Slot, 1)
    obj:Start_PACKED(context.new())
    lu.assertEquals(obj.Status, "Complete")
    local resp = obj:GetResult_PACKED(context.new())
    lu.assertEquals(resp.Status, "Failed")
    lu.assertEquals(resp.Description, "")
    log:notice('- test dft button cell finish')
    obj:Stop_PACKED(context.new())
    lu.assertEquals(obj.Status, "Unstart")
end

-- 测试装备项 DftFlash
local function test_dft_flash(bus)
    local obj = mdb.get_object(bus, DFTFLASH_PATH, DFT_INTERFACE)
    lu.assertEquals(obj.Slot, 1)
    obj:Start_PACKED(context.new())
    lu.assertEquals(obj.Status, "Testing")
    obj:Stop_PACKED(context.new())
    lu.assertEquals(obj.Status, "Unstart")
    local resp = obj:GetResult_PACKED(context.new())
    lu.assertEquals(resp.Status, "Succeed")
    lu.assertEquals(resp.Description, "")
    log:notice('- test dft flash finish')
end

-- 测试装备项 DftJTAG
local function test_dft_jtag(bus)
    local obj = mdb.get_object(bus, DFTFLASH_PATH, DFT_INTERFACE)
    lu.assertEquals(obj.Slot, 1)
    obj:Start_PACKED(context.new())
    lu.assertEquals(obj.Status, "Testing")
    obj:Stop_PACKED(context.new())
    lu.assertEquals(obj.Status, "Unstart")
    local resp = obj:GetResult_PACKED(context.new())
    lu.assertEquals(resp.Status, "Succeed")
    lu.assertEquals(resp.Description, "")
    log:notice('- test dft JTAG finish')
end

-- 测试装备项 DftCpld
local function test_dft_cpld(bus)
    local obj = mdb.get_object(bus, DFTCPLD_PATH, DFT_INTERFACE)
    lu.assertEquals(obj.Slot, 1)
    obj:Start_PACKED(context.new())
    lu.assertEquals(obj.Status, "Testing")
    obj:Stop_PACKED(context.new())
    lu.assertEquals(obj.Status, "Unstart")
    local resp = obj:GetResult_PACKED(context.new())
    lu.assertEquals(resp.Status, "Succeed")
    lu.assertEquals(resp.Description, "")
    log:notice('- test dft cpld finish')
end

-- 测试装备项 DftIOTest
local function test_dft_io(bus)
    local obj = mdb.get_object(bus, DFTIOTEST_PATH, DFT_INTERFACE)
    lu.assertEquals(obj.Slot, 1)
    obj:Start_PACKED(context.new())
    lu.assertEquals(obj.Status, "Complete")
    obj:Stop_PACKED(context.new())
    lu.assertEquals(obj.Status, "Unstart")
    local resp = obj:GetResult_PACKED(context.new())
    lu.assertEquals(resp.Status, "Succeed")
    lu.assertEquals(resp.Description, "")
    log:notice('- test dft io test finish')
end

-- 测试装备项 DftHwchannel
local function test_dft_hwchannel(bus)
    local obj = mdb.get_object(bus, DFTHWCHANNEL_PATH, DFT_INTERFACE)
    lu.assertEquals(obj.Slot, 1)
    obj:Start_PACKED(context.new())
    lu.assertEquals(obj.Status, "Complete")
    local resp = obj:GetResult_PACKED(context.new())
    lu.assertEquals(resp.Status, "Succeed")
    lu.assertEquals(resp.Description, "")
    obj:Stop_PACKED(context.new())
    lu.assertEquals(obj.Status, "Unstart")
    log:notice('- test dft HWCHANNEL finish')
end

function test_memory.test_all_dft_method(bus)
    test_dft_12v0_vlot(bus)
    test_dft_5v0_vlot(bus)
    test_dft_3v3_vlot(bus)
    test_dft_card_presence(bus)
    test_dft_button_cell(bus)
    test_dft_flash(bus)
    test_dft_jtag(bus)
    test_dft_cpld(bus)
    test_dft_io(bus)
    test_dft_hwchannel(bus)
end

return test_memory
