-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local log = require 'mc.logging'
local unit = require 'unit_manager.class.unit.unit'

local test_logic_fw = {}

local function test_cpld_self_test(bus)
    unit.fail_count_list = {}
    unit:ctor(bus, {name = "Expboard_1", CpldStatus = 0}, nil, nil)
    local ok = unit:cpld_self_test_process(1, 0x55)
    lu.assertEquals(ok, false)
end

local function test_cpld_self_test2(bus)
    unit.fail_count_list = {}
    unit:ctor(bus, {name = "Expboard_1", CpldStatus = 0, CpldTestReg = 0x55}, nil, nil)
    local ok = unit:cpld_self_test_process(1, 0x55)
    lu.assertEquals(ok, true)
end

function test_logic_fw.main(bus)
    log:info('================ test logic fw start ================')
    test_cpld_self_test(bus)
    test_cpld_self_test2(bus)
    log:info('================ test logic fw complete ================')
end

return test_logic_fw
