-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local skynet = require 'skynet'
require 'skynet.manager'
local log = require 'mc.logging'
local gen_hw_app = require 'general_hardware_app'

local app = nil
local app_cmd = {}

function app_cmd.exit()
    skynet.timeout(0, function()
        log:info('[general_hardware] service exit')
        skynet.exit()
    end)
end

skynet.start(function()
    skynet.uniqueservice('sd_bus')
    skynet.register('.general_hardware')
    app = gen_hw_app.new()
    local ok, handler = pcall(require, 'general_hardware_manufacture_app')
    if ok then
        local manufacture = handler.new(app)
        manufacture:init()
    end
    skynet.dispatch('lua', function(_, _, cmd, ...)
        local func = assert(app_cmd[cmd])
        skynet.ret(skynet.pack(func(...)))
    end)
end)