-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require 'mc.class'

local vrd_power_obj = class()

function vrd_power_obj:update_info(voltage, amps, temperature)
    self.mds_obj.Voltage = voltage or 1.1
    self.mds_obj.CurrentAmps = amps
    self.mds_obj.TemperatureCelsius = temperature or 1.1
end

function vrd_power_obj:set_power_to_invalid()
    self.mds_obj.Voltage = 255.00
    self.mds_obj.CurrentAmps = 255.00
    self.mds_obj.TemperatureCelsius = 0xFFFF
end

function vrd_power_obj:reset_power()
    self.mds_obj.Voltage = 0
    self.mds_obj.CurrentAmps = 255.00
    self.mds_obj.TemperatureCelsius = 0xFFFF
end

function vrd_power_obj:is_vrd_power_obj_in_cpu(system_id, cpu_id)
    if self.mds_obj.SystemId == system_id and self.mds_obj.CpuId == cpu_id then
        return true
    end
    return false
end

function vrd_power_obj:is_vrd_power_obj_by_type(power_type, die_id)
    if self.mds_obj.Type == power_type and self.mds_obj.DieId == die_id then
        return true
    end
    return false
end

function vrd_power_obj:ctor(obj, position)
    self.mds_obj = obj
    self.position = position
end

return vrd_power_obj