-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local class = require 'mc.class'
local c_clu = require 'unit_manager.class.unit.clu.clu'
local cmn = require 'common'
local skynet = require 'skynet'

---@class FanBoard: CLU @风扇背板
local c_fan_board = class(c_clu)

function c_fan_board:update_powerwatts(power)
    pcall(function()
        -- 先用pcall包裹，逐步替换为新版bmc后再优化csr中配置，合并powerwatts与powerwattsexp，防止set失败冲日志
        self:set_prop('PowerWatts', power)
    end)
end

function c_fan_board:task_update_power_watts()
    local ok, power
    skynet.fork_loop({count = 0}, function ()
        cmn.skynet.sleep(6000) -- 启动阶段等待1分钟后更新风扇功耗
        while true do
            -- 需要通过硬件访问题代理服务从硬件读取风扇功耗, 因此用pcall进行读取
            ok, power = pcall(function()
                return self:get_prop('PowerWattsExp')
            end)
            if ok then
                -- 更新到资源树属性上，需要优化：此属性通过Scanner获取硬件值，利用表达式语法进行二次处理
                self:update_powerwatts(power)
            end
            cmn.skynet.sleep(6000)
        end
    end)
end

function c_fan_board:task_update()
    self:task_update_power_watts()
    self:task_update_mcu_version()
end

return c_fan_board