-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local class = require 'mc.class'
local singleton = require 'mc.singleton'

---@class ServiceManager @服务管理类,管理general_hardware服务中所有子服务的生命周期
local c_service_manager = class()

function c_service_manager:register(name, service)
    if not self.service_coll[name] then
        self.service_coll[name] = service
    end
end

function c_service_manager:unregister(name)
    self.service_coll[name] = nil
end

function c_service_manager:get_service(name)
    return self.service_coll[name]
end

function c_service_manager:ctor()
    self.service_coll = {}
end

return singleton(c_service_manager)