-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: 用于刷新属性
local agent_map = {
    [0] = require 'retimer.agent.retimer_agent_5902l',
    [3] = require 'retimer.agent.retimer_agent_M88RT51632'
}

local agent = {}

agent.new = function(chip_type, ...)
    local chip_agent = agent_map[chip_type]
    if not chip_agent then
        return
    end
    return chip_agent.new(...)
end

return agent