-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: 升级的通信接口
local class = require 'mc.class'
local interface = class()

function interface:init()
end

function interface:ctor(chip, protocol_type, address)
    self.chip = chip
    self.address = address
    self.type = protocol_type
end

--- @function 获取厂商id
function interface:get_vendor_id(sub_comp)
end

--- @function 获取版本信息
function interface:get_version(sub_comp)
end

--- @function 查询升级对象状态
function interface:query_upgrade_status()
end

--- @function 发送启动升级命令
function interface:start_upgrade()
end

--- @function 文件传输
function interface:send_upgrade_file(sub_comp, data, send_params_list, process)
end

--- @function 初始化升级通道
--- @return any true/false
function interface:init_upgrade(sub_comp, lib_size, bin_size)
end

--- @function 升级生效，涉及重启
--- @return any true/false
function interface:take_upgrade_effect()
end

return interface