-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


-- Description: 定义模块需要的通用常量和方法
local MCU_ENUMS = require 'mcu.enum.mcu_enums'
local defs = {}

defs.ALL_SYSTEM_ID = 255

defs.RET = {
    OK = 0,
    ERR = (-1),
    MCU_UPGRADE_FAIL = 34,
    OTHERS_UPGRADING = 248,
    IN_UPGRADING = 36
}

defs.convert_component = {
    ["Mcu"] = {type = MCU_ENUMS.SUB_COMPONENT_TYPE.T_MCU, id = nil, idex = nil},
    ["Cpld"] = {type = MCU_ENUMS.SUB_COMPONENT_TYPE.T_CPLD, id = nil, idex = nil},
    ["Vrd"] = {type = MCU_ENUMS.SUB_COMPONENT_TYPE.T_VRD, id = 0x17, idex = 0x7D},
    ["Pll"] = {type = MCU_ENUMS.SUB_COMPONENT_TYPE.T_PLL, id = nil, idex = nil},
    ["UsbHub"] = {type = MCU_ENUMS.SUB_COMPONENT_TYPE.T_USBHUB, id = nil, idex = nil},
    ["Vdm"] = {type = MCU_ENUMS.SUB_COMPONENT_TYPE.T_VDM, id = 0x1d, idex = 0x1D000005}
}

defs.UPGRADE_VRD_VALID_FILE_DIR = '/data/backup/vrd/up_cfg/'
defs.VRD_NAME = 'Vrd'
defs.VRD_HPM = 'vrd.hpm'

defs.firmware_type = {
    MCU = 'Mcu',
    VDM = 'Vdm',
    VRD = 'Vrd'
}

return defs