-- Copyright (c) Huawei Technologies co., Ltd. 2023-2023. All rights reserved.
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN \"AS IS\" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Author: lijiabao
-- Create: 2025-02-12
-- Description: maintenance service
local log = require 'mc.logging'
local task = require 'mc.mdb.task_mgmt'

local create_task_err_code <const> = task.create_code
local update_task_err_code <const> = task.update_code

local module = {}

-- 创建任务
function module.create_task(bus, task_name, path, timeout)
    local res, task_err, id = task.create_task(bus, task_name, path, timeout)
    if res ~= create_task_err_code.TASK_CREATE_SUCCESSFUL then
        log:error('Create task failed, res: %d', res)
        error(task_err)
    end

    return id
end

-- 更新任务属性
function module.update_task_prop(task_id, prop)
    local res = task.update_task(task_id, prop)
    if res ~= update_task_err_code.TASK_UPDATE_SUCCESSFUL then
        log:error('Update task failed, res: %d', res)
    end
end

return module