-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local ipmi = require 'ipmi'
local comp_code = ipmi.types.Cc
local class = require 'mc.class'
local singleton = require 'mc.singleton'
local msg = require 'general_hardware.ipmi.ipmi_message'
local gpu_service = require 'gpu_service.gpu_service'
local log = require 'mc.logging'

local MANUFACTURE_ID<const> = 0x0007db
local gpu_ipmi = class()

function gpu_ipmi:ctor(bus)
    self.bus = bus
end

function gpu_ipmi:get_gpu_chip_info(req, ctx, ...)
    local _, bus, device, func = string.match(req.Data, '^(%x+):(%x+):(%x+).(%x+)$')
    if not bus or not device or not func then
        log:error('ipmi convert bdf info failed')
        return msg.GetGpuChipInfoRsp.new(comp_code.ParmOutOfRange, MANUFACTURE_ID, '')
    end
    local chip_type, cc = gpu_service.get_instance():get_gpu_model(
        tonumber(bus, 16), tonumber(device, 16), tonumber(func, 16))
    return msg.GetGpuChipInfoRsp.new(cc, MANUFACTURE_ID, chip_type)
end

return singleton(gpu_ipmi)