-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local dpu_enums = {}

-- MCU故障码对应的 EventKeyId、事件描述  数据来自v2 g_fault_code_desc_event_table
dpu_enums.mcu_error_code_desc_event_table = {
    [8501] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_5V0_VRD_MOS_ADC exceeds the overvoltage threshold." },
    [8502] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_5V0_VRD_MOS_ADC lower than the overvoltage threshold." },
    [8503] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_5V0_VRD_MOS_ADC get fail." },
    [8504] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_5V0_DRMOS_ADC exceeds the overvoltage threshold." },
    [8505] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_5V0_DRMOS_ADC lower than the overvoltage threshold." },
    [8506] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_5V0_DRMOS_ADC get fail." },
    [8507] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_2V5_VPP_AB_ADC exceeds the overvoltage threshold." },
    [8508] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_2V5_VPP_AB_ADC lower than the overvoltage threshold." },
    [8509] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_2V5_VPP_AB_ADC get fail." },
    [8510] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_VCC_12V0_ADC exceeds the overvoltage threshold." },
    [8511] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_VCC_12V0_ADC lower than the overvoltage threshold." },
    [8512] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_VCC_12V0_ADC get fail." },
    [8513] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_VCC_12V_CABLE_ADC exceeds the overvoltage threshold." },
    [8514] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_VCC_12V_CABLE_ADC exceeds the overvoltage threshold." },
    [8515] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_VCC_12V_CABLE_ADC get fail." },
    [8516] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_VCC_12V_GOLD_ADC exceeds the overvoltage threshold." },
    [8517] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_VCC_12V_GOLD_ADC lower than the overvoltage threshold." },
    [8518] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_VCC_12V_GOLD_ADC get fail." },
    [8519] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_VCC_3V3_ADC exceeds the overvoltage threshold." },
    [8520] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_VCC_3V3_ADC lower than the overvoltage threshold." },
    [8521] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_VCC_3V3_ADC get fail." },
    [8522] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_0V75_DVDD_FIX exceeds the overvoltage threshold." },
    [8523] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_0V75_DVDD_FIX lower than the overvoltage threshold." },
    [8524] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_0V75_DVDD_FIX get fail." },
    [8525] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_0V75_DVDD_AVS exceeds the overvoltage threshold." },
    [8526] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_0V75_DVDD_AVS lower than the overvoltage threshold." },
    [8527] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_0V75_DVDD_AVS get fail." },
    [8528] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_2V5_VPP_CD_ADC exceeds the overvoltage threshold." },
    [8529] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_2V5_VPP_CD_ADC lower than the overvoltage threshold." },
    [8530] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_2V5_VPP_CD_ADC get fail." },
    [8531] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_2V5_VPP_B_ADC exceeds the overvoltage threshold." },
    [8532] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_2V5_VPP_B_ADCC lower than the overvoltage threshold." },
    [8533] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_2V5_VPP_B_ADC get fail." },
    [8534] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_0V75_AVDD_SDS32 exceeds the overvoltage threshold." },
    [8535] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_0V75_AVDD_SDS32 lower than the overvoltage threshold." },
    [8536] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_0V75_AVDD_SDS32 get fail." },
    [8537] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_0V8_DVDD_DDR exceeds the overvoltage threshold." },
    [8538] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_0V8_DVDD_DDR lower than the overvoltage threshold." },
    [8539] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_0V8_DVDD_DDR get fail." },
    [8540] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_1V2_AVDD_SDS_FIX exceeds the overvoltage threshold." },
    [8541] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_1V2_AVDD_SDS_FIX lower than the overvoltage threshold." },
    [8542] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_1V2_AVDD_SDS_FIX get fail." },
    [8543] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_0V8_AVDD_SDS60_FIX exceeds the overvoltage threshold." },
    [8544] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_0V8_AVDD_SDS60_FIX lower than the overvoltage threshold." },
    [8545] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_0V8_AVDD_SDS60_FIX get fail." },
    [8546] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_1V2_CPU_DDR_VDDQ_CD exceeds the overvoltage threshold." },
    [8547] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_1V2_CPU_DDR_VDDQ_CD lower than the overvoltage threshold." },
    [8548] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_1V2_CPU_DDR_VDDQ_CD get fail." },
    [8549] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_1V2_CPU_DDR_VDDQ_AB exceeds the overvoltage threshold." },
    [8550] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_1V2_CPU_DDR_VDDQ_AB lower than the overvoltage threshold." },
    [8551] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_1V2_CPU_DDR_VDDQ_AB get fail." },
    [8552] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_1V2_CPU_DDR_VDDQ exceeds the overvoltage threshold." },
    [8553] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_1V2_CPU_DDR_VDDQ lower than the overvoltage threshold." },
    [8554] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_1V2_CPU_DDR_VDDQ get fail." },
    [8555] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_1V8_DVDD_1823E exceeds the overvoltage threshold." },
    [8556] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_1V8_DVDD_1823E lower than the overvoltage threshold." },
    [8557] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_1V8_DVDD_1823E get fail." },
    [8560] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good PG_V_VCC_12V_CABLE Abnormal." },
    [8561] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good PG_V_VCC_12V_GOLD Abnormal." },
    [8562] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good PG_V_VCC_3V3 Abnormal." },
    [8563] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good PG_V_3V3_VRD Abnormal." },
    [8564] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good PG_V_VCC_1V8 Abnormal." },
    [8565] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good PG_V_1V2_VDDQ_AB Abnormal." },
    [8566] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good PG_V_1V2_CPU_HVCC Abnormal." },
    [8567] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good PG_V_1V2_VDDQ_CD Abnormal." },
    [8568] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good PG_V_1V2_VDDQ Abnormal." },
    [8569] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good PG_V_VCC_5V0 Abnormal." },
    [8570] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good PG_V_0V8_DVDD_DDR Abnormal." },
    [8571] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good PG_V_0V75_DVDD_AVS Abnormal." },
    [8572] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good PG_V_2V5_VPP_AB Abnormal." },
    [8573] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good PG_V_2V5_VPP_CD Abnormal." },
    [8574] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good PG_V_0V75_DVDD_FIX Abnormal." },
    [8575] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good PG_V_0V6_VTT_AB Abnormal." },
    [8576] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good PG_V_0V6_VTT_CD Abnormal." },
    [8577] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good PG_AVDD_SDS_FIX_1V2 Abnormal." },
    [8608] = { "PCIeCard.PCIeCardVoltageMajor", "Abnormal power down." },
    [8612] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good PG_VCC_1V8_EFUSE Abnormal." },
    [8613] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good PG_V_VCC_1V1_WX1860 Abnormal." },
    [8650] = { "PCIeCard.PCIeCardVoltageMajor", "V_VCC_3V3 power-on timeout." },
    [8651] = { "PCIeCard.PCIeCardVoltageMajor", "V_VCC_5V0 power-on timeout." },
    [8652] = { "PCIeCard.PCIeCardVoltageMajor", "V_VRD_3V3 power-on timeout." },
    [8653] = { "PCIeCard.PCIeCardVoltageMajor", "V_VCC_1V1_WX1860 power-on timeout." },
    [8654] = { "PCIeCard.PCIeCardVoltageMajor", "V_VCC_1V8 power-on timeout." },
    [8655] = { "PCIeCard.PCIeCardVoltageMajor", "V_2V5_VPP_AB power-on timeout." },
    [8656] = { "PCIeCard.PCIeCardVoltageMajor", "V_2V5_VPP_CD power-on timeout." },
    [8657] = { "PCIeCard.PCIeCardVoltageMajor", "V_0V8_DVDD_DDR power-on timeout." },
    [8658] = { "PCIeCard.PCIeCardVoltageMajor", "V_0V75_DVDD_AVS power-on timeout." },
    [8659] = { "PCIeCard.PCIeCardVoltageMajor", "V_0V75_DVDD_FIX power-on timeout." },
    [8660] = { "PCIeCard.PCIeCardVoltageMajor", "V_1V2_AVDD_SDS_FIX power-on timeout." },
    [8661] = { "PCIeCard.PCIeCardVoltageMajor", "V_1V2_CPU_DDR_VDDQ_AB power-on timeout." },
    [8662] = { "PCIeCard.PCIeCardVoltageMajor", "V_1V2_CPU_DDR_VDDQ_CD power-on timeout." },
    [8663] = { "PCIeCard.PCIeCardVoltageMajor", "VCC_1V8_EFUSE power-on timeout." },
    [8664] = { "PCIeCard.PCIeCardVoltageMajor", "V_VTT_AB_0V6 power-on timeout." },
    [8665] = { "PCIeCard.PCIeCardVoltageMajor", "V_VTT_CD_0V6 power-on timeout." },
    [14848] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_DVDD075_NPU_FIX exceeds the overvoltage threshold." },
    [14849] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_DVDD075_NPU_FIX lower than the overvoltage threshold." },
    [14850] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_DVDD075_NPU_FIX get fail." },
    [14851] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_DVDD085_CPU_AVS exceeds the overvoltage threshold." },
    [14852] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_DVDD085_CPU_AVS lower than the overvoltage threshold." },
    [14853] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_DVDD085_CPU_AVS get fail." },
    [14854] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_DVDD08_DDR_FIX exceeds the overvoltage threshold." },
    [14855] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_DVDD08_DDR_FIX lower than the overvoltage threshold." },
    [14856] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_DVDD08_DDR_FIX get fail." },
    [14857] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_DVDD085_SPU_FIX exceeds the overvoltage threshold." },
    [14858] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_DVDD085_SPU_FIX lower than the overvoltage threshold." },
    [14859] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_DVDD085_SPU_FIX get fail." },
    [14860] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_DVDD08_SIO_FIX exceeds the overvoltage threshold." },
    [14861] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_DVDD08_SIO_FIX lower than the overvoltage threshold." },
    [14862] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_DVDD08_SIO_FIX get fail." },
    [14863] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_VCC_1V2_SDS exceeds the overvoltage threshold." },
    [14864] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_VCC_1V2_SDS lower than the overvoltage threshold." },
    [14865] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_VCC_1V2_SDS get fail." },
    [14866] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_VCC_1V8_CLK exceeds the overvoltage threshold." },
    [14867] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_VCC_1V8_CLK lower than the overvoltage threshold." },
    [14868] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_VCC_1V8_CLK get fail." },
    [14869] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_VCC_1V8 exceeds the overvoltage threshold." },
    [14870] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_VCC_1V8 lower than the overvoltage threshold." },
    [14871] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_VCC_1V8 get fail." },
    [14872] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_U1_DVDD11_DDRIO_FIX exceeds the overvoltage threshold." },
    [14873] = { "PCIeCard.PCIeCardVoltageMajor",
        "Voltage V_U1_DVDD11_DDRIO_FIX lower than the overvoltage threshold." },
    [14874] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_U1_DVDD11_DDRIO_FIX get fail." },
    [14875] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_U0_DVDD11_DDRIO_FIX exceeds the overvoltage threshold." },
    [14876] = { "PCIeCard.PCIeCardVoltageMajor",
        "Voltage V_U0_DVDD11_DDRIO_FIX lower than the overvoltage threshold." },
    [14877] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_U0_DVDD11_DDRIO_FIX get fail." },
    [14878] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_12V_CON_IN_ADC exceeds the overvoltage threshold." },
    [14879] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_12V_CON_IN_ADC lower than the overvoltage threshold." },
    [14880] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_12V_CON_IN_ADC get fail." },
    [14881] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_VCC_0V75_LVCC exceeds the overvoltage threshold." },
    [14882] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_VCC_0V75_LVCC lower than the overvoltage threshold." },
    [14883] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_VCC_0V75_LVCC get fail." },
    [14884] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good PG_VCC_1V8_CLK Abnormal." },
    [14885] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good V_DVDD08_DDR_FIX Abnormal." },
    [14886] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good V_DVDD075_NPU_FIX Abnormal." },
    [14887] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good V_DVDD085_CPU_AVS Abnormal." },
    [14888] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good V_DVDD085_SPU_FIX Abnormal." },
    [14889] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good V_DVDD08_SIO_FIX Abnormal." },
    [14890] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good V_VCC_1V1_D1_DDR Abnormal." },
    [14891] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good V_VCC_1V1_D2_DDR Abnormal." },
    [14892] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good V_VCC_1V2_SDS Abnormal." },
    [14893] = { "PCIeCard.PCIeCardVoltageMajor", "V_VCC_1V8_CLK power-on timeout." },
    [14894] = { "PCIeCard.PCIeCardVoltageMajor", "V_DVDD08_DDR_FIX power-on timeout." },
    [14895] = { "PCIeCard.PCIeCardVoltageMajor", "V_DVDD075_NPU_FIX power-on timeout." },
    [14896] = { "PCIeCard.PCIeCardVoltageMajor", "V_DVDD085_CPU_AVS power-on timeout." },
    [14897] = { "PCIeCard.PCIeCardVoltageMajor", "V_DVDD085_SPU_FIX power-on timeout." },
    [14898] = { "PCIeCard.PCIeCardVoltageMajor", "V_DVDD08_SIO_FIX power-on timeout." },
    [14899] = { "PCIeCard.PCIeCardVoltageMajor", "V_VCC_1V1_D1_DDR power-on timeout." },
    [14900] = { "PCIeCard.PCIeCardVoltageMajor", "V_VCC_1V1_D2_DDR power-on timeout." },
    [14901] = { "PCIeCard.PCIeCardVoltageMajor", "V_VCC_1V2_SDS power-on timeout." },
    [8920] = { "PCIeCard.PCIeCardVoltageMajor", "Abnormal voltage." },
    [8921] = { "PCIeCard.PCIeVoltCollectionFailed", "Voltage collection failed." },
    [8192] = { "PCIeCard.PCIeCardCPUMajor", "CPU Bist Error." },
    [8351] = { "PCIeCard.PCIeCardCPUMajor", "CPU NFE IERR." },
    [8198] = { "PCIeCard.PCIeCardCPUMajor", "CPU MCE/AER Error." },
    [8200] = { "PCIeCard.PCIeCardCPUMajor", "CPU Core Isolation." },
    [8201] = { "PCIeCard.PCIeCardCPUMajor", "CPU Margin Fail." },
    [8352] = { "PCIeCard.PCIeCardCPUMajor", "Cache Timeout." },
    [8353] = { "PCIeCard.PCIeCardCPUMajor", "Memory Request Timeout." },
    [8900] = { "PCIeCard.PCIeCardCPUMajor", "Core component exception." },
    [8199] = { "PCIeCard.PCIeCardCPUMinor", "CPU Frequency Reduction." },
    [8600] = { "PCIeCard.PCIeCardCPUMinor", "ME Heartbeat Error." },
    [8350] = { "PCIeCard.PCIeCardCPUMinor", "CPU Cache Error." },
    [8901] = { "PCIeCard.PCIeCardCPUMinor", "Core component exception." },
    [8196] = { "PCIeCard.PCIeCardCPUCritical", "CPU Fatal Error." },
    [8197] = { "PCIeCard.PCIeCardCPUCritical", "CPU FE IERR." },
    [8262] = { "PCIeCard.PCIeCardCPUCritical", "CPU Overheat Shutdown." },
    [8203] = { "PCIeCard.PCIeCardMemoryMinor", "Memory self-check failure." },
    [8214] = { "PCIeCard.PCIeCardMemoryMinor", "Memory Isolation." },
    [8204] = { "PCIeCard.PCIeCardMemoryMajor", "Memory UCE." },
    [8206] = { "PCIeCard.PCIeCardMemoryMajor", "Memory Channel A Isolation." },
    [8207] = { "PCIeCard.PCIeCardMemoryMajor", "Memory Channel B Isolation." },
    [8208] = { "PCIeCard.PCIeCardMemoryMajor", "Memory Channel C Isolation." },
    [8209] = { "PCIeCard.PCIeCardMemoryMajor", "Memory Channel D Isolation." },
    [8210] = { "PCIeCard.PCIeCardMemoryMajor", "Memory Initialization Error." },
    [8213] = { "PCIeCard.PCIeCardMemoryMajor", "Memory Pre-failure." },
    [8231] = { "PCIeCard.PCIeCardNetCardMinor", "Network Port Link Fail." },
    [8233] = { "PCIeCard.PCIeCardNetCardMinor", "The negotiated working rate of the network port is incorrect." },
    [8236] = { "PCIeCard.PCIeCardNetCardMinor", "Abnormal optical power." },
    [8604] = { "PCIeCard.PCIeCardNetCardMinor", "The SmartNIC RTC abnormal." },
    [8228] = { "PCIeCard.PCIeCardNetCardMajor", "NIC health status abnormal." },
    [8230] = { "PCIeCard.PCIeCardNetCardMajor", "Abnormal optical module Status." },
    [8232] = { "PCIeCard.PCIeCardNetCardMajor",
        "The Serdes bit error rate of the network port exceeds the threshold." },
    [8234] = { "PCIeCard.PCIeCardNetCardMajor", "The Network mac address get fail." },
    [8235] = { "PCIeCard.PCIeCardNetCardMajor", "MPU heartbeat lost." },
    [8402] = { "PCIeCard.PCIeCardNetCardMajor", "NIC BOM gets fail." },
    [8401] = { "PCIeCard.PCIeCardNetCardMajor", "NIC Elabel gets fail." },
    [8606] = { "PCIeCard.PCIeCardNetCardMajor", "NIC Flash life warning." },
    [8602] = { "PCIeCard.PCIeCardNetCardMajor", "SmartNIC has critical RAS error." },
    [8668] = { "PCIeCard.PCIeCardNetCardMajor", "Optical module 1 overcurrent." },
    [8669] = { "PCIeCard.PCIeCardNetCardMajor", "Optical module 2 overcurrent." },
    [8674] = { "PCIeCard.PCIeCardNetCardMajor", "Optical module 3 overcurrent." },
    [8675] = { "PCIeCard.PCIeCardNetCardMajor", "Optical module 4 overcurrent." },
    [8940] = { "PCIeCard.PCIeCardNetCardMajor", "Abnormal network port status." },
    [8354] = { "PCIeCard.PCIeCardNetCardCritical", "NIC chip Error." },
    [8603] = { "PCIeCard.PCIeCardNetCardCritical", "SmartNIC has fatal RAS error." },
    [8239] = { "PCIeCard.PCIeCardStartingMinor", "Watchdog timeout alarm during BIOS loading." },
    [8243] = { "PCIeCard.PCIeCardStartingMinor", "Watchdog timeout alarm during OS loading." },
    [8607] = { "PCIeCard.PCIeCardStartingMinor", "NIC Firmware Verify Fail." },
    [8960] = { "PCIeCard.PCIeCardStartingMinor", "Operating system startup failed." },
    [8240] = { "PCIeCard.PCIeCardStartingMajor", "BIOS Startup Fail." },
    [8241] = { "PCIeCard.PCIeCardStartingMajor", "Watchdog timeout alarm during PXE." },
    [8242] = { "PCIeCard.PCIeCardStartingMajor", "OS Verify Fail." },
    [8244] = { "PCIeCard.PCIeCardStartingMajor", "OS Startup Fail." },
    [8400] = { "PCIeCard.PCIeCardStartingMajor", "BIOS Firmware upgrade fail." },
    [8601] = { "PCIeCard.PCIeCardStartingMajor", "NIC Firmware upgrade fail." },
    [8671] = { "PCIeCard.PCIeCardStartingMajor", "Failed to obtain the hard disk boot option." },
    [8672] = { "PCIeCard.PCIeCardStartingMajor", "The certificate is about to expire." },
    [8673] = { "PCIeCard.PCIeCardStartingMajor", "SPU Heartbeat lost." },
    [8961] = { "PCIeCard.PCIeCardStartingMajor", "Operating system startup failed." },
    [8605] = { "PCIeCard.PCIeCardMcuMinor", "CPLD abnormal heartbeat" },
    [8359] = { "PCIeCard.PCIeCardMcuMinor", "MCU Firmware(Single Partition) integrity check fail." },
    [8246] = { "PCIeCard.PCIeCardMcuMajor", "MCU SRAM abnormal." },
    [8610] = { "PCIeCard.PCIeCardMcuMajor", "VRD inspect abnormal." },
    [8670] = { "PCIeCard.PCIeCardMcuMajor", "VRD overcurrent." },
    [8247] = { "PCIeCard.PCIeCardMcuMajor", "MCU Flash abnormal." },
    [8248] = { "PCIeCard.PCIeCardMcuMajor", "MCU RTC abnormal." },
    [8390] = { "PCIeCard.PCIeCardMcuMajor", "MCU Firmware upgrade fail." },
    [8391] = { "PCIeCard.PCIeCardMcuMajor", "MCU Firmware failed to take effect." },
    [8245] = { "PCIeCard.PCIeCardMcuMajor", "MCU Firmware integrity check fail." },
    [8358] = { "PCIeCard.PCIeCardMcuMajor", "VRD Firmware upgrade fail." },
    [8357] = { "PCIeCard.PCIeCardMcuMajor", "VRD inspect fail." },
    [8389] = { "PCIeCard.PCIeCardMcuMajor", "VRD inspect inconsistent data." },
    [8970] = { "PCIeCard.PCIeCardMcuMinor", "Firmware upgrade exception." },
    [8250] = { "PCIeCard.PCIeCardTemperatureMajor", "The CPU temperature of SmartNIC too high." },
    [8259] = { "PCIeCard.PCIeCardTemperatureMajor", "The temperature of Air outlet 2 get fail." },
    [8355] = { "PCIeCard.PCIeCardTemperatureMajor", "The temperature of Air inlet 1 abnormal." },
    [8356] = { "PCIeCard.PCIeCardTemperatureMajor", "The temperature of Air inlet 1 get fail." },
    [8260] = { "PCIeCard.PCIeCardTemperatureMajor", "The temperature of NIC abnormal." },
    [8261] = { "PCIeCard.PCIeCardTemperatureMajor", "The temperature of NIC get fail." },
    [8251] = { "PCIeCard.PCIeCardTemperatureMajor", "The CPU temperature of SmartNIC get fail." },
    [8252] = { "PCIeCard.PCIeCardTemperatureMajor", "The temperature of optical module 1 abnormal." },
    [8253] = { "PCIeCard.PCIeCardTemperatureMajor", "The temperature of optical module 1 get fail." },
    [8254] = { "PCIeCard.PCIeCardTemperatureMajor", "The temperature of optical module 2 abnormal." },
    [8255] = { "PCIeCard.PCIeCardTemperatureMajor", "The temperature of optical module 2 get fail." },
    [8676] = { "PCIeCard.PCIeCardTemperatureMajor", "The temperature of optical module 3 abnormal." },
    [8677] = { "PCIeCard.PCIeCardTemperatureMajor", "The temperature of optical module 3 get fail." },
    [8678] = { "PCIeCard.PCIeCardTemperatureMajor", "The temperature of optical module 4 abnormal." },
    [8679] = { "PCIeCard.PCIeCardTemperatureMajor", "The temperature of optical module 4 get fail." },
    [8256] = { "PCIeCard.PCIeCardTemperatureMajor", "The temperature of Air outlet 1 abnormal." },
    [8257] = { "PCIeCard.PCIeCardTemperatureMajor", "The temperature of Air outlet 1 get fail." },
    [8258] = { "PCIeCard.PCIeCardTemperatureMajor", "The temperature of Air outlet 2 abnormal." },
    [8910] = { "PCIeCard.PCIeCardTemperatureMajor", "Temperature abnormality." },
    [8911] = { "PCIeCard.PCIeTempCollectionFailed", "Temperature collection failed." },
    [8264] = { "PCIeCard.PCIeCardCableMinor", "NCSI cable Not Present." },
    [8341] = { "PCIeCard.PCIeCardPowerConsumptionMajor", "The power consumption of SmartNIC exceeds threshold." },
    [8342] = { "PCIeCard.PCIeCardPowerConsumptionMajor", "The power consumption of SmartNIC gets fail." },
    [8980] = { "PCIeCard.PCIeCardPowerConsumptionMajor", "Abnormal power." },
    [8981] = { "PCIeCard.PCIePowerCollectionFailed", "Power collection failed." },
    [8348] = { "PCIeCard.PCIeCardNetworkMinor", "NIC bandwidth abnormal." },
    [8349] = { "PCIeCard.PCIeCardNetworkMinor", "NIC speed abnormal." },
    [8950] = { "PCIeCard.PCIeCardNetworkMinor", "Abnormal NIC link status" },
    [8347] = { "PCIeCard.PCIeCardNetworkMajor", "NIC Not Present." },
    [8226] = { "PCIeCard.PCIeCardDiskMinor", "M.2 Smart Status Error." },
    [8227] = { "PCIeCard.PCIeCardDiskMinor", "M.2 Smart Information Get Fail." },
    [4096] = { "PCIeCard.PCIeCardDiskMinor", "M.2 dynamic life Warning." },
    [4097] = { "PCIeCard.PCIeCardDiskMinor", "M.2 Write amplification Warning." },
    [4099] = { "PCIeCard.PCIeCardDiskMinor", "M.2 health level too low." },
    [8930] = { "PCIeCard.PCIeCardDiskMinor", "The storage medium consumption rate is too high." },
    [8216] = { "PCIeCard.PCIeCardDiskMajor", "M.2 A Not present." },
    [8217] = { "PCIeCard.PCIeCardDiskMajor", "M.2 B Not present." },
    [8218] = { "PCIeCard.PCIeCardDiskMajor", "M.2 A Scan Fail." },
    [8219] = { "PCIeCard.PCIeCardDiskMajor", "M.2 B Scan Fail." },
    [8220] = { "PCIeCard.PCIeCardDiskMajor", "M.2 Life Warning." },
    [8223] = { "PCIeCard.PCIeCardDiskMajor", "M.2 Raid Status Error." },
    [8666] = { "PCIeCard.PCIeCardDiskMajor", "M.2 A overcurrent." },
    [8667] = { "PCIeCard.PCIeCardDiskMajor", "M.2 B overcurrent." },
    [4098] = { "PCIeCard.PCIeCardDiskMajor", "M.2 Spare superblock numbers too few." },
    [8266] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage PVCCANA_CPU exceeds the overvoltage threshold." },
    [8267] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage PVCCANA_CPU lower than the undervoltage threshold." },
    [8268] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage PVCCANA_CPU get fail." },
    [8269] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage P1V05 exceeds the overvoltage threshold." },
    [8270] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage P1V05 lower than the undervoltage threshold." },
    [8271] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage P1V05 get fail." },
    [8272] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage PVDDQ_AB_CPU exceeds the overvoltage threshold." },
    [8273] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage PVDDQ_AB_CPU lower than the undervoltage threshold." },
    [8274] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage PVDDQ_AB_CPU get fail." },
    [8275] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage PVNN_PCH exceeds the overvoltage threshold." },
    [8276] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage PVNN_PCH lower than the undervoltage threshold." },
    [8277] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage PVNN_PCH get fail." },
    [8278] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage P3V3_AUX exceeds the overvoltage threshold." },
    [8279] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage P3V3_AUX lower than the undervoltage threshold." },
    [8280] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage P3V3_AUX get fail." },
    [8281] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage PVDDQ_EF_CPU exceeds the overvoltage threshold." },
    [8282] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage PVDDQ_EF_CPU lower than the undervoltage threshold." },
    [8283] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage PVDDQ_EF_CPU get fail." },
    [8284] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage PVPP_CPU_AB exceeds the overvoltage threshold." },
    [8285] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage PVPP_CPU_AB lower than the undervoltage threshold." },
    [8286] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage PVPP_CPU_AB get fail." },
    [8287] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage PVPP_CPU_EF exceeds the overvoltage threshold." },
    [8288] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage PVPP_CPU_EF lower than the undervoltage threshold." },
    [8289] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage PVPP_CPU_EF get fail." },
    [8290] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage P3V3_VCC exceeds the overvoltage threshold." },
    [8291] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage P3V3_VCC lower than the undervoltage threshold." },
    [8292] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage P3V3_VCC get fail." },
    [8293] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage PVTT_CPU_AB exceeds the overvoltage threshold." },
    [8294] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage PVTT_CPU_AB lower than the undervoltage threshold." },
    [8295] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage PVTT_CPU_AB get fail." },
    [8296] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage PVTT_CPU_EF exceeds the overvoltage threshold." },
    [8297] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage PVTT_CPU_EF lower than the undervoltage threshold." },
    [8298] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage PVTT_CPU_EF get fail." },
    [8299] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage P12V exceeds the overvoltage threshold." },
    [8300] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage P12V lower than the undervoltage threshold." },
    [8301] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage P12V get fail." },
    [8302] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_VCC_VRD_MOS exceeds the overvoltage threshold." },
    [8303] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_VCC_VRD_MOS lower than the undervoltage threshold." },
    [8304] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_VCC_VRD_MOS get fail." },
    [8305] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage P3V3_STBY exceeds the overvoltage threshold." },
    [8306] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage P3V3_STBY lower than the undervoltage threshold." },
    [8307] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage P3V3_STBY get fail." },
    [8308] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage PVCCIN_CPU exceeds the overvoltage threshold." },
    [8309] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage PVCCIN_CPU lower than the undervoltage threshold." },
    [8310] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage PVCCIN_CPU get fail." },
    [8311] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage P1V8_AUX exceeds the overvoltage threshold." },
    [8312] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage P1V8_AUX lower than the undervoltage threshold." },
    [8313] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage P1V8_AUX get fail." },
    [8314] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_1V8_DVDD exceeds the overvoltage threshold." },
    [8315] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_1V8_DVDD lower than the undervoltage threshold." },
    [8316] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_1V8_DVDD get fail." },
    [8317] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_0V8_AVDD_NIC exceeds the overvoltage threshold." },
    [8318] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_0V8_AVDD_NIC lower than the undervoltage threshold." },
    [8319] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_0V8_AVDD_NIC get fail." },
    [8320] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_VCC_3V3 exceeds the overvoltage threshold." },
    [8321] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_VCC_3V3 lower than the undervoltage threshold." },
    [8322] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_VCC_3V3 get fail." },
    [8323] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_0V75_DVDD_NIC exceeds the overvoltage threshold." },
    [8324] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_0V75_DVDD_NIC lower than the undervoltage threshold." },
    [8325] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_0V75_DVDD_NIC get fail." },
    [8326] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_VCC_5V0 exceeds the overvoltage threshold." },
    [8327] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_VCC_5V0 lower than the undervoltage threshold." },
    [8328] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_VCC_5V0 get fail." },
    [8329] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_1V2_AVDD_NIC exceeds the overvoltage threshold." },
    [8330] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_1V2_AVDD_NIC lower than the undervoltage threshold." },
    [8331] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_1V2_AVDD_NIC get fail." },
    [8332] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_VCC_12V0 exceeds the overvoltage threshold." },
    [8333] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_VCC_12V0 lower than the undervoltage threshold." },
    [8334] = { "PCIeCard.PCIeCardVoltageMajor", "Voltage V_VCC_12V0 get fail." },
    [8360] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good PG_P12V_R_PC11 Abnormal." },
    [8361] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good PG_NIC_VRD Abnormal." },
    [8362] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good PWRGD_P5V_DRMOS_PF12 Abnormal." },
    [8363] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good PWRGD_P3V3_VCC_R_PF11  Abnormal." },
    [8364] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good PG_P3V3_VRD_R_PG9 Abnormal." },
    [8365] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good PG_P3V3_AUX_R_PD9 Abnormal." },
    [8366] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good PG_P1V8_AUX_R_PI10 Abnormal." },
    [8367] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good PWRGD_PVNN_PCH_R2_PE6 Abnormal." },
    [8368] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good PWRGD_P1V05_CPU_PH4 Abnormal." },
    [8369] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good PG_SLPS45_PB6 Abnormal." },
    [8370] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good PG_PVTT_CPU_AB_R_PI9 Abnormal." },
    [8371] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good PG_PVTT_CPU_EF_R_PE8 Abnormal." },
    [8372] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good PG_PVPP_CPU_AB_R2_PG1 Abnormal." },
    [8373] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good PG_CPUVTT_PE7 Abnormal." },
    [8374] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good PG_CPUVTT_PF15 Abnormal." },
    [8375] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good PWRGD_PVDDQ_EF_R2_PG0 PG Abnormal." },
    [8376] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good PWRGD_PVCCANA_CPU_R2_PF13 Abnormal." },
    [8377] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good PG_PVCCIN_CPU_R_PH5 Abnormal." },
    [8378] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good PG_CPU_OUTLVC_PI8 Abnormal." },
    [8379] = { "PCIeCard.PCIeCardVoltageMajor", "Power Good PG_PLTRST_PD12 Abnormal." },
    [8380] = { "PCIeCard.PCIeCardVoltageMajor", "Power up fail." }
}

dpu_enums.DPU_UPGRADING = 0
dpu_enums.BOARD_ID_FOR_SP923H = 239
dpu_enums.REQUEST_NUM_FOR_COMMON = 1
dpu_enums.REQUEST_NUM_FOR_SP923H = 2

dpu_enums.pxe_option_table = {
    [0] = "UefiIpv4",
    [4] = "UefiIpv6",
    [5] = "UefiIpv4AndIpv6",
    ['DPU'] = {
        [1] = "HttpsIpv4",        -- SDI不支持该项
        [2] = "HttpsIpv4AndIpv6", -- SDI不支持该项
        [3] = "HttpsIpv6"         -- SDI不支持该项
    }
}

dpu_enums.pxe_option_table_r = {
    ["UefiIpv4"] = 0,
    ["UefiIpv6"] = 4,
    ["UefiIpv4AndIpv6"] = 5,
    ['DPU'] = {
        ["HttpsIpv4"] = 1,        -- SDI不支持该项
        ["HttpsIpv4AndIpv6"] = 2, -- SDI不支持该项
        ["HttpsIpv6"] = 3         -- SDI不支持该项
    }
}

dpu_enums.function_class = {
    [5] = 'SDI',
    [11] = 'DPU'
}

dpu_enums.secure_boot_table = {
    [true] = 'enable',
    [false] = 'disable',
    [1] = "enable",
    [0] = 'disable'
}

return dpu_enums
