-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local SmBios = {}

---@class SmBios.SystemId
---@field SystemId integer
local TSystemId = {}
TSystemId.__index = TSystemId
TSystemId.group = {}

local function TSystemId_from_obj(obj)
    return setmetatable(obj, TSystemId)
end

function TSystemId.new(SystemId)
    return TSystemId_from_obj({SystemId = SystemId})
end
---@param obj SmBios.SystemId
function TSystemId:init_from_obj(obj)
    self.SystemId = obj.SystemId
end

function TSystemId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSystemId.group)
end

TSystemId.from_obj = TSystemId_from_obj

TSystemId.proto_property = {'SystemId'}

TSystemId.default = {0}

TSystemId.struct = {{name = 'SystemId', is_array = false, struct = nil}}

function TSystemId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemId', self.SystemId, 'uint8', true, errs, need_convert)

    TSystemId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSystemId.proto_property, errs, need_convert)
    return self
end

function TSystemId:unpack(_)
    return self.SystemId
end

SmBios.SystemId = TSystemId

---@class SmBios.DiffFileName
---@field DiffFileName string
local TDiffFileName = {}
TDiffFileName.__index = TDiffFileName
TDiffFileName.group = {}

local function TDiffFileName_from_obj(obj)
    return setmetatable(obj, TDiffFileName)
end

function TDiffFileName.new(DiffFileName)
    return TDiffFileName_from_obj({DiffFileName = DiffFileName})
end
---@param obj SmBios.DiffFileName
function TDiffFileName:init_from_obj(obj)
    self.DiffFileName = obj.DiffFileName
end

function TDiffFileName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDiffFileName.group)
end

TDiffFileName.from_obj = TDiffFileName_from_obj

TDiffFileName.proto_property = {'DiffFileName'}

TDiffFileName.default = {''}

TDiffFileName.struct = {{name = 'DiffFileName', is_array = false, struct = nil}}

function TDiffFileName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DiffFileName', self.DiffFileName, 'string', true, errs, need_convert)

    TDiffFileName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDiffFileName.proto_property, errs, need_convert)
    return self
end

function TDiffFileName:unpack(_)
    return self.DiffFileName
end

SmBios.DiffFileName = TDiffFileName

---@class SmBios.FileName
---@field FileName string
local TFileName = {}
TFileName.__index = TFileName
TFileName.group = {}

local function TFileName_from_obj(obj)
    return setmetatable(obj, TFileName)
end

function TFileName.new(FileName)
    return TFileName_from_obj({FileName = FileName})
end
---@param obj SmBios.FileName
function TFileName:init_from_obj(obj)
    self.FileName = obj.FileName
end

function TFileName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFileName.group)
end

TFileName.from_obj = TFileName_from_obj

TFileName.proto_property = {'FileName'}

TFileName.default = {''}

TFileName.struct = {{name = 'FileName', is_array = false, struct = nil}}

function TFileName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FileName', self.FileName, 'string', true, errs, need_convert)

    TFileName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFileName.proto_property, errs, need_convert)
    return self
end

function TFileName:unpack(_)
    return self.FileName
end

SmBios.FileName = TFileName

---@class SmBios.FileChange
---@field FileChange integer
local TFileChange = {}
TFileChange.__index = TFileChange
TFileChange.group = {}

local function TFileChange_from_obj(obj)
    return setmetatable(obj, TFileChange)
end

function TFileChange.new(FileChange)
    return TFileChange_from_obj({FileChange = FileChange})
end
---@param obj SmBios.FileChange
function TFileChange:init_from_obj(obj)
    self.FileChange = obj.FileChange
end

function TFileChange:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFileChange.group)
end

TFileChange.from_obj = TFileChange_from_obj

TFileChange.proto_property = {'FileChange'}

TFileChange.default = {0}

TFileChange.struct = {{name = 'FileChange', is_array = false, struct = nil}}

function TFileChange:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FileChange', self.FileChange, 'uint8', true, errs, need_convert)

    TFileChange:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFileChange.proto_property, errs, need_convert)
    return self
end

function TFileChange:unpack(_)
    return self.FileChange
end

SmBios.FileChange = TFileChange

---@class SmBios.SmBiosUpdatedFlag
---@field SmBiosUpdatedFlag integer
local TSmBiosUpdatedFlag = {}
TSmBiosUpdatedFlag.__index = TSmBiosUpdatedFlag
TSmBiosUpdatedFlag.group = {}

local function TSmBiosUpdatedFlag_from_obj(obj)
    return setmetatable(obj, TSmBiosUpdatedFlag)
end

function TSmBiosUpdatedFlag.new(SmBiosUpdatedFlag)
    return TSmBiosUpdatedFlag_from_obj({SmBiosUpdatedFlag = SmBiosUpdatedFlag})
end
---@param obj SmBios.SmBiosUpdatedFlag
function TSmBiosUpdatedFlag:init_from_obj(obj)
    self.SmBiosUpdatedFlag = obj.SmBiosUpdatedFlag
end

function TSmBiosUpdatedFlag:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSmBiosUpdatedFlag.group)
end

TSmBiosUpdatedFlag.from_obj = TSmBiosUpdatedFlag_from_obj

TSmBiosUpdatedFlag.proto_property = {'SmBiosUpdatedFlag'}

TSmBiosUpdatedFlag.default = {0}

TSmBiosUpdatedFlag.struct = {{name = 'SmBiosUpdatedFlag', is_array = false, struct = nil}}

function TSmBiosUpdatedFlag:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SmBiosUpdatedFlag', self.SmBiosUpdatedFlag, 'uint8', true, errs, need_convert)

    TSmBiosUpdatedFlag:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSmBiosUpdatedFlag.proto_property, errs, need_convert)
    return self
end

function TSmBiosUpdatedFlag:unpack(_)
    return self.SmBiosUpdatedFlag
end

SmBios.SmBiosUpdatedFlag = TSmBiosUpdatedFlag

---@class SmBios.SmBiosStatus
---@field SmBiosStatus integer
local TSmBiosStatus = {}
TSmBiosStatus.__index = TSmBiosStatus
TSmBiosStatus.group = {}

local function TSmBiosStatus_from_obj(obj)
    return setmetatable(obj, TSmBiosStatus)
end

function TSmBiosStatus.new(SmBiosStatus)
    return TSmBiosStatus_from_obj({SmBiosStatus = SmBiosStatus})
end
---@param obj SmBios.SmBiosStatus
function TSmBiosStatus:init_from_obj(obj)
    self.SmBiosStatus = obj.SmBiosStatus
end

function TSmBiosStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSmBiosStatus.group)
end

TSmBiosStatus.from_obj = TSmBiosStatus_from_obj

TSmBiosStatus.proto_property = {'SmBiosStatus'}

TSmBiosStatus.default = {0}

TSmBiosStatus.struct = {{name = 'SmBiosStatus', is_array = false, struct = nil}}

function TSmBiosStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SmBiosStatus', self.SmBiosStatus, 'uint8', true, errs, need_convert)

    TSmBiosStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSmBiosStatus.proto_property, errs, need_convert)
    return self
end

function TSmBiosStatus:unpack(_)
    return self.SmBiosStatus
end

SmBios.SmBiosStatus = TSmBiosStatus

---@class SmBios.Family
---@field Family string
local TFamily = {}
TFamily.__index = TFamily
TFamily.group = {}

local function TFamily_from_obj(obj)
    return setmetatable(obj, TFamily)
end

function TFamily.new(Family)
    return TFamily_from_obj({Family = Family})
end
---@param obj SmBios.Family
function TFamily:init_from_obj(obj)
    self.Family = obj.Family
end

function TFamily:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFamily.group)
end

TFamily.from_obj = TFamily_from_obj

TFamily.proto_property = {'Family'}

TFamily.default = {''}

TFamily.struct = {{name = 'Family', is_array = false, struct = nil}}

function TFamily:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Family', self.Family, 'string', true, errs, need_convert)

    TFamily:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFamily.proto_property, errs, need_convert)
    return self
end

function TFamily:unpack(_)
    return self.Family
end

SmBios.Family = TFamily

---@class SmBios.SKUNumber
---@field SKUNumber string
local TSKUNumber = {}
TSKUNumber.__index = TSKUNumber
TSKUNumber.group = {}

local function TSKUNumber_from_obj(obj)
    return setmetatable(obj, TSKUNumber)
end

function TSKUNumber.new(SKUNumber)
    return TSKUNumber_from_obj({SKUNumber = SKUNumber})
end
---@param obj SmBios.SKUNumber
function TSKUNumber:init_from_obj(obj)
    self.SKUNumber = obj.SKUNumber
end

function TSKUNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSKUNumber.group)
end

TSKUNumber.from_obj = TSKUNumber_from_obj

TSKUNumber.proto_property = {'SKUNumber'}

TSKUNumber.default = {''}

TSKUNumber.struct = {{name = 'SKUNumber', is_array = false, struct = nil}}

function TSKUNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SKUNumber', self.SKUNumber, 'string', true, errs, need_convert)

    TSKUNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSKUNumber.proto_property, errs, need_convert)
    return self
end

function TSKUNumber:unpack(_)
    return self.SKUNumber
end

SmBios.SKUNumber = TSKUNumber

---@class SmBios.Version
---@field Version string
local TVersion = {}
TVersion.__index = TVersion
TVersion.group = {}

local function TVersion_from_obj(obj)
    return setmetatable(obj, TVersion)
end

function TVersion.new(Version)
    return TVersion_from_obj({Version = Version})
end
---@param obj SmBios.Version
function TVersion:init_from_obj(obj)
    self.Version = obj.Version
end

function TVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVersion.group)
end

TVersion.from_obj = TVersion_from_obj

TVersion.proto_property = {'Version'}

TVersion.default = {''}

TVersion.struct = {{name = 'Version', is_array = false, struct = nil}}

function TVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Version', self.Version, 'string', true, errs, need_convert)

    TVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVersion.proto_property, errs, need_convert)
    return self
end

function TVersion:unpack(_)
    return self.Version
end

SmBios.Version = TVersion

---@class SmBios.SerialNumber
---@field SerialNumber string
local TSerialNumber = {}
TSerialNumber.__index = TSerialNumber
TSerialNumber.group = {}

local function TSerialNumber_from_obj(obj)
    return setmetatable(obj, TSerialNumber)
end

function TSerialNumber.new(SerialNumber)
    return TSerialNumber_from_obj({SerialNumber = SerialNumber})
end
---@param obj SmBios.SerialNumber
function TSerialNumber:init_from_obj(obj)
    self.SerialNumber = obj.SerialNumber
end

function TSerialNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSerialNumber.group)
end

TSerialNumber.from_obj = TSerialNumber_from_obj

TSerialNumber.proto_property = {'SerialNumber'}

TSerialNumber.default = {''}

TSerialNumber.struct = {{name = 'SerialNumber', is_array = false, struct = nil}}

function TSerialNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SerialNumber', self.SerialNumber, 'string', true, errs, need_convert)

    TSerialNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSerialNumber.proto_property, errs, need_convert)
    return self
end

function TSerialNumber:unpack(_)
    return self.SerialNumber
end

SmBios.SerialNumber = TSerialNumber

SmBios.interface = mdb.register_interface('bmc.kepler.Systems.SmBios', {
    SerialNumber = {'s', nil, true, nil, false},
    Version = {'s', nil, true, nil, false},
    SKUNumber = {'s', nil, true, nil, false},
    Family = {'s', nil, true, nil, false},
    SmBiosStatus = {'y', nil, true, nil, false},
    SmBiosUpdatedFlag = {'y', nil, true, nil, false},
    FileChange = {'y', nil, true, nil, false},
    FileName = {'s', nil, true, nil, false},
    DiffFileName = {'s', nil, true, nil, false},
    SystemId = {'y', nil, true, nil, false}
}, {}, {})

return SmBios
