-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Retimer = {}

---@class Retimer.HealthStatus
---@field HealthStatus integer
local THealthStatus = {}
THealthStatus.__index = THealthStatus
THealthStatus.group = {}

local function THealthStatus_from_obj(obj)
    return setmetatable(obj, THealthStatus)
end

function THealthStatus.new(HealthStatus)
    return THealthStatus_from_obj({HealthStatus = HealthStatus})
end
---@param obj Retimer.HealthStatus
function THealthStatus:init_from_obj(obj)
    self.HealthStatus = obj.HealthStatus
end

function THealthStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THealthStatus.group)
end

THealthStatus.from_obj = THealthStatus_from_obj

THealthStatus.proto_property = {'HealthStatus'}

THealthStatus.default = {0}

THealthStatus.struct = {{name = 'HealthStatus', is_array = false, struct = nil}}

function THealthStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'HealthStatus', self.HealthStatus, 'uint8', true, errs, need_convert)

    THealthStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THealthStatus.proto_property, errs, need_convert)
    return self
end

function THealthStatus:unpack(_)
    return self.HealthStatus
end

Retimer.HealthStatus = THealthStatus

---@class Retimer.DieID
---@field DieID string
local TDieID = {}
TDieID.__index = TDieID
TDieID.group = {}

local function TDieID_from_obj(obj)
    return setmetatable(obj, TDieID)
end

function TDieID.new(DieID)
    return TDieID_from_obj({DieID = DieID})
end
---@param obj Retimer.DieID
function TDieID:init_from_obj(obj)
    self.DieID = obj.DieID
end

function TDieID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDieID.group)
end

TDieID.from_obj = TDieID_from_obj

TDieID.proto_property = {'DieID'}

TDieID.default = {''}

TDieID.struct = {{name = 'DieID', is_array = false, struct = nil}}

function TDieID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DieID', self.DieID, 'string', true, errs, need_convert)

    TDieID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDieID.proto_property, errs, need_convert)
    return self
end

function TDieID:unpack(_)
    return self.DieID
end

Retimer.DieID = TDieID

---@class Retimer.ChipLocation
---@field ChipLocation string
local TChipLocation = {}
TChipLocation.__index = TChipLocation
TChipLocation.group = {}

local function TChipLocation_from_obj(obj)
    return setmetatable(obj, TChipLocation)
end

function TChipLocation.new(ChipLocation)
    return TChipLocation_from_obj({ChipLocation = ChipLocation})
end
---@param obj Retimer.ChipLocation
function TChipLocation:init_from_obj(obj)
    self.ChipLocation = obj.ChipLocation
end

function TChipLocation:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChipLocation.group)
end

TChipLocation.from_obj = TChipLocation_from_obj

TChipLocation.proto_property = {'ChipLocation'}

TChipLocation.default = {''}

TChipLocation.struct = {{name = 'ChipLocation', is_array = false, struct = nil}}

function TChipLocation:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ChipLocation', self.ChipLocation, 'string', true, errs, need_convert)

    TChipLocation:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChipLocation.proto_property, errs, need_convert)
    return self
end

function TChipLocation:unpack(_)
    return self.ChipLocation
end

Retimer.ChipLocation = TChipLocation

---@class Retimer.TemperatureCelsius
---@field TemperatureCelsius integer
local TTemperatureCelsius = {}
TTemperatureCelsius.__index = TTemperatureCelsius
TTemperatureCelsius.group = {}

local function TTemperatureCelsius_from_obj(obj)
    return setmetatable(obj, TTemperatureCelsius)
end

function TTemperatureCelsius.new(TemperatureCelsius)
    return TTemperatureCelsius_from_obj({TemperatureCelsius = TemperatureCelsius})
end
---@param obj Retimer.TemperatureCelsius
function TTemperatureCelsius:init_from_obj(obj)
    self.TemperatureCelsius = obj.TemperatureCelsius
end

function TTemperatureCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTemperatureCelsius.group)
end

TTemperatureCelsius.from_obj = TTemperatureCelsius_from_obj

TTemperatureCelsius.proto_property = {'TemperatureCelsius'}

TTemperatureCelsius.default = {0}

TTemperatureCelsius.struct = {{name = 'TemperatureCelsius', is_array = false, struct = nil}}

function TTemperatureCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TemperatureCelsius', self.TemperatureCelsius, 'int16', true, errs, need_convert)

    TTemperatureCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTemperatureCelsius.proto_property, errs, need_convert)
    return self
end

function TTemperatureCelsius:unpack(_)
    return self.TemperatureCelsius
end

Retimer.TemperatureCelsius = TTemperatureCelsius

---@class Retimer.FirmwareVersion
---@field FirmwareVersion string
local TFirmwareVersion = {}
TFirmwareVersion.__index = TFirmwareVersion
TFirmwareVersion.group = {}

local function TFirmwareVersion_from_obj(obj)
    return setmetatable(obj, TFirmwareVersion)
end

function TFirmwareVersion.new(FirmwareVersion)
    return TFirmwareVersion_from_obj({FirmwareVersion = FirmwareVersion})
end
---@param obj Retimer.FirmwareVersion
function TFirmwareVersion:init_from_obj(obj)
    self.FirmwareVersion = obj.FirmwareVersion
end

function TFirmwareVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFirmwareVersion.group)
end

TFirmwareVersion.from_obj = TFirmwareVersion_from_obj

TFirmwareVersion.proto_property = {'FirmwareVersion'}

TFirmwareVersion.default = {''}

TFirmwareVersion.struct = {{name = 'FirmwareVersion', is_array = false, struct = nil}}

function TFirmwareVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FirmwareVersion', self.FirmwareVersion, 'string', true, errs, need_convert)

    TFirmwareVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFirmwareVersion.proto_property, errs, need_convert)
    return self
end

function TFirmwareVersion:unpack(_)
    return self.FirmwareVersion
end

Retimer.FirmwareVersion = TFirmwareVersion

---@class Retimer.ChipType
---@field ChipType integer
local TChipType = {}
TChipType.__index = TChipType
TChipType.group = {}

local function TChipType_from_obj(obj)
    return setmetatable(obj, TChipType)
end

function TChipType.new(ChipType)
    return TChipType_from_obj({ChipType = ChipType})
end
---@param obj Retimer.ChipType
function TChipType:init_from_obj(obj)
    self.ChipType = obj.ChipType
end

function TChipType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChipType.group)
end

TChipType.from_obj = TChipType_from_obj

TChipType.proto_property = {'ChipType'}

TChipType.default = {0}

TChipType.struct = {{name = 'ChipType', is_array = false, struct = nil}}

function TChipType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ChipType', self.ChipType, 'uint8', true, errs, need_convert)

    TChipType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChipType.proto_property, errs, need_convert)
    return self
end

function TChipType:unpack(_)
    return self.ChipType
end

Retimer.ChipType = TChipType

---@class Retimer.ChipName
---@field ChipName string
local TChipName = {}
TChipName.__index = TChipName
TChipName.group = {}

local function TChipName_from_obj(obj)
    return setmetatable(obj, TChipName)
end

function TChipName.new(ChipName)
    return TChipName_from_obj({ChipName = ChipName})
end
---@param obj Retimer.ChipName
function TChipName:init_from_obj(obj)
    self.ChipName = obj.ChipName
end

function TChipName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChipName.group)
end

TChipName.from_obj = TChipName_from_obj

TChipName.proto_property = {'ChipName'}

TChipName.default = {''}

TChipName.struct = {{name = 'ChipName', is_array = false, struct = nil}}

function TChipName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ChipName', self.ChipName, 'string', true, errs, need_convert)

    TChipName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChipName.proto_property, errs, need_convert)
    return self
end

function TChipName:unpack(_)
    return self.ChipName
end

Retimer.ChipName = TChipName

Retimer.interface = mdb.register_interface('bmc.kepler.Systems.Retimer', {
    ChipName = {'s', nil, true, nil, false},
    ChipType = {'y', nil, true, nil, false},
    FirmwareVersion = {'s', nil, true, nil, false},
    TemperatureCelsius = {'n', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false},
    ChipLocation = {'s', nil, true, nil, false},
    DieID = {'s', nil, true, nil, false},
    HealthStatus = {'y', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false}
}, {}, {})

return Retimer
