-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Pmu = {}

---@class Pmu.SFPMaxTemperature
---@field SFPMaxTemperature integer
local TSFPMaxTemperature = {}
TSFPMaxTemperature.__index = TSFPMaxTemperature
TSFPMaxTemperature.group = {}

local function TSFPMaxTemperature_from_obj(obj)
    return setmetatable(obj, TSFPMaxTemperature)
end

function TSFPMaxTemperature.new(SFPMaxTemperature)
    return TSFPMaxTemperature_from_obj({SFPMaxTemperature = SFPMaxTemperature})
end
---@param obj Pmu.SFPMaxTemperature
function TSFPMaxTemperature:init_from_obj(obj)
    self.SFPMaxTemperature = obj.SFPMaxTemperature
end

function TSFPMaxTemperature:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSFPMaxTemperature.group)
end

TSFPMaxTemperature.from_obj = TSFPMaxTemperature_from_obj

TSFPMaxTemperature.proto_property = {'SFPMaxTemperature'}

TSFPMaxTemperature.default = {0}

TSFPMaxTemperature.struct = {{name = 'SFPMaxTemperature', is_array = false, struct = nil}}

function TSFPMaxTemperature:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SFPMaxTemperature', self.SFPMaxTemperature, 'uint16', true, errs, need_convert)

    TSFPMaxTemperature:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSFPMaxTemperature.proto_property, errs, need_convert)
    return self
end

function TSFPMaxTemperature:unpack(_)
    return self.SFPMaxTemperature
end

Pmu.SFPMaxTemperature = TSFPMaxTemperature

---@class Pmu.PmuVersion
---@field PmuVersion string
local TPmuVersion = {}
TPmuVersion.__index = TPmuVersion
TPmuVersion.group = {}

local function TPmuVersion_from_obj(obj)
    return setmetatable(obj, TPmuVersion)
end

function TPmuVersion.new(PmuVersion)
    return TPmuVersion_from_obj({PmuVersion = PmuVersion})
end
---@param obj Pmu.PmuVersion
function TPmuVersion:init_from_obj(obj)
    self.PmuVersion = obj.PmuVersion
end

function TPmuVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPmuVersion.group)
end

TPmuVersion.from_obj = TPmuVersion_from_obj

TPmuVersion.proto_property = {'PmuVersion'}

TPmuVersion.default = {''}

TPmuVersion.struct = {{name = 'PmuVersion', is_array = false, struct = nil}}

function TPmuVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PmuVersion', self.PmuVersion, 'string', true, errs, need_convert)

    TPmuVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPmuVersion.proto_property, errs, need_convert)
    return self
end

function TPmuVersion:unpack(_)
    return self.PmuVersion
end

Pmu.PmuVersion = TPmuVersion

---@class Pmu.PmuType
---@field PmuType integer
local TPmuType = {}
TPmuType.__index = TPmuType
TPmuType.group = {}

local function TPmuType_from_obj(obj)
    return setmetatable(obj, TPmuType)
end

function TPmuType.new(PmuType)
    return TPmuType_from_obj({PmuType = PmuType or 0})
end
---@param obj Pmu.PmuType
function TPmuType:init_from_obj(obj)
    self.PmuType = obj.PmuType or 0
end

function TPmuType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPmuType.group)
end

TPmuType.from_obj = TPmuType_from_obj

TPmuType.proto_property = {'PmuType'}

TPmuType.default = {0}

TPmuType.struct = {{name = 'PmuType', is_array = false, struct = nil}}

function TPmuType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PmuType', self.PmuType, 'uint8', true, errs, need_convert)

    TPmuType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPmuType.proto_property, errs, need_convert)
    return self
end

function TPmuType:unpack(_)
    return self.PmuType
end

Pmu.PmuType = TPmuType

---@class Pmu.Status
---@field Status integer
local TStatus = {}
TStatus.__index = TStatus
TStatus.group = {}

local function TStatus_from_obj(obj)
    return setmetatable(obj, TStatus)
end

function TStatus.new(Status)
    return TStatus_from_obj({Status = Status or 0})
end
---@param obj Pmu.Status
function TStatus:init_from_obj(obj)
    self.Status = obj.Status or 0
end

function TStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStatus.group)
end

TStatus.from_obj = TStatus_from_obj

TStatus.proto_property = {'Status'}

TStatus.default = {0}

TStatus.struct = {{name = 'Status', is_array = false, struct = nil}}

function TStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Status', self.Status, 'uint8', true, errs, need_convert)

    TStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStatus.proto_property, errs, need_convert)
    return self
end

function TStatus:unpack(_)
    return self.Status
end

Pmu.Status = TStatus

---@class Pmu.SystemId
---@field SystemId integer
local TSystemId = {}
TSystemId.__index = TSystemId
TSystemId.group = {}

local function TSystemId_from_obj(obj)
    return setmetatable(obj, TSystemId)
end

function TSystemId.new(SystemId)
    return TSystemId_from_obj({SystemId = SystemId})
end
---@param obj Pmu.SystemId
function TSystemId:init_from_obj(obj)
    self.SystemId = obj.SystemId
end

function TSystemId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSystemId.group)
end

TSystemId.from_obj = TSystemId_from_obj

TSystemId.proto_property = {'SystemId'}

TSystemId.default = {0}

TSystemId.struct = {{name = 'SystemId', is_array = false, struct = nil}}

function TSystemId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemId', self.SystemId, 'uint8', true, errs, need_convert)

    TSystemId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSystemId.proto_property, errs, need_convert)
    return self
end

function TSystemId:unpack(_)
    return self.SystemId
end

Pmu.SystemId = TSystemId

---@class Pmu.GetPcieSubVidDidRsp
---@field VendorId integer
---@field DeviceId integer
local TGetPcieSubVidDidRsp = {}
TGetPcieSubVidDidRsp.__index = TGetPcieSubVidDidRsp
TGetPcieSubVidDidRsp.group = {}

local function TGetPcieSubVidDidRsp_from_obj(obj)
    return setmetatable(obj, TGetPcieSubVidDidRsp)
end

function TGetPcieSubVidDidRsp.new(VendorId, DeviceId)
    return TGetPcieSubVidDidRsp_from_obj({VendorId = VendorId, DeviceId = DeviceId})
end
---@param obj Pmu.GetPcieSubVidDidRsp
function TGetPcieSubVidDidRsp:init_from_obj(obj)
    self.VendorId = obj.VendorId
    self.DeviceId = obj.DeviceId
end

function TGetPcieSubVidDidRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPcieSubVidDidRsp.group)
end

TGetPcieSubVidDidRsp.from_obj = TGetPcieSubVidDidRsp_from_obj

TGetPcieSubVidDidRsp.proto_property = {'VendorId', 'DeviceId'}

TGetPcieSubVidDidRsp.default = {0, 0}

TGetPcieSubVidDidRsp.struct = {
    {name = 'VendorId', is_array = false, struct = nil}, {name = 'DeviceId', is_array = false, struct = nil}
}

function TGetPcieSubVidDidRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'VendorId', self.VendorId, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceId', self.DeviceId, 'uint16', false, errs, need_convert)

    TGetPcieSubVidDidRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPcieSubVidDidRsp.proto_property, errs, need_convert)
    return self
end

function TGetPcieSubVidDidRsp:unpack(_)
    return self.VendorId, self.DeviceId
end

Pmu.GetPcieSubVidDidRsp = TGetPcieSubVidDidRsp

---@class Pmu.GetPcieSubVidDidReq
---@field SystemId integer
---@field IsLocal boolean
---@field CpuId integer
---@field Bus integer
---@field Device integer
---@field Function integer
local TGetPcieSubVidDidReq = {}
TGetPcieSubVidDidReq.__index = TGetPcieSubVidDidReq
TGetPcieSubVidDidReq.group = {}

local function TGetPcieSubVidDidReq_from_obj(obj)
    return setmetatable(obj, TGetPcieSubVidDidReq)
end

function TGetPcieSubVidDidReq.new(SystemId, IsLocal, CpuId, Bus, Device, Function)
    return TGetPcieSubVidDidReq_from_obj({
        SystemId = SystemId,
        IsLocal = IsLocal,
        CpuId = CpuId,
        Bus = Bus,
        Device = Device,
        Function = Function
    })
end
---@param obj Pmu.GetPcieSubVidDidReq
function TGetPcieSubVidDidReq:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.IsLocal = obj.IsLocal
    self.CpuId = obj.CpuId
    self.Bus = obj.Bus
    self.Device = obj.Device
    self.Function = obj.Function
end

function TGetPcieSubVidDidReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPcieSubVidDidReq.group)
end

TGetPcieSubVidDidReq.from_obj = TGetPcieSubVidDidReq_from_obj

TGetPcieSubVidDidReq.proto_property = {'SystemId', 'IsLocal', 'CpuId', 'Bus', 'Device', 'Function'}

TGetPcieSubVidDidReq.default = {0, false, 0, 0, 0, 0}

TGetPcieSubVidDidReq.struct = {
    {name = 'SystemId', is_array = false, struct = nil}, {name = 'IsLocal', is_array = false, struct = nil},
    {name = 'CpuId', is_array = false, struct = nil}, {name = 'Bus', is_array = false, struct = nil},
    {name = 'Device', is_array = false, struct = nil}, {name = 'Function', is_array = false, struct = nil}
}

function TGetPcieSubVidDidReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemId', self.SystemId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'IsLocal', self.IsLocal, 'bool', false, errs, need_convert)
    validate.Optional(prefix .. 'CpuId', self.CpuId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Bus', self.Bus, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Device', self.Device, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Function', self.Function, 'uint8', false, errs, need_convert)

    TGetPcieSubVidDidReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPcieSubVidDidReq.proto_property, errs, need_convert)
    return self
end

function TGetPcieSubVidDidReq:unpack(_)
    return self.SystemId, self.IsLocal, self.CpuId, self.Bus, self.Device, self.Function
end

Pmu.GetPcieSubVidDidReq = TGetPcieSubVidDidReq

---@class Pmu.GetPcieVidDidRsp
---@field VendorId integer
---@field DeviceId integer
local TGetPcieVidDidRsp = {}
TGetPcieVidDidRsp.__index = TGetPcieVidDidRsp
TGetPcieVidDidRsp.group = {}

local function TGetPcieVidDidRsp_from_obj(obj)
    return setmetatable(obj, TGetPcieVidDidRsp)
end

function TGetPcieVidDidRsp.new(VendorId, DeviceId)
    return TGetPcieVidDidRsp_from_obj({VendorId = VendorId, DeviceId = DeviceId})
end
---@param obj Pmu.GetPcieVidDidRsp
function TGetPcieVidDidRsp:init_from_obj(obj)
    self.VendorId = obj.VendorId
    self.DeviceId = obj.DeviceId
end

function TGetPcieVidDidRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPcieVidDidRsp.group)
end

TGetPcieVidDidRsp.from_obj = TGetPcieVidDidRsp_from_obj

TGetPcieVidDidRsp.proto_property = {'VendorId', 'DeviceId'}

TGetPcieVidDidRsp.default = {0, 0}

TGetPcieVidDidRsp.struct = {
    {name = 'VendorId', is_array = false, struct = nil}, {name = 'DeviceId', is_array = false, struct = nil}
}

function TGetPcieVidDidRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'VendorId', self.VendorId, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceId', self.DeviceId, 'uint16', false, errs, need_convert)

    TGetPcieVidDidRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPcieVidDidRsp.proto_property, errs, need_convert)
    return self
end

function TGetPcieVidDidRsp:unpack(_)
    return self.VendorId, self.DeviceId
end

Pmu.GetPcieVidDidRsp = TGetPcieVidDidRsp

---@class Pmu.GetPcieVidDidReq
---@field SystemId integer
---@field IsLocal boolean
---@field CpuId integer
---@field Bus integer
---@field Device integer
---@field Function integer
local TGetPcieVidDidReq = {}
TGetPcieVidDidReq.__index = TGetPcieVidDidReq
TGetPcieVidDidReq.group = {}

local function TGetPcieVidDidReq_from_obj(obj)
    return setmetatable(obj, TGetPcieVidDidReq)
end

function TGetPcieVidDidReq.new(SystemId, IsLocal, CpuId, Bus, Device, Function)
    return TGetPcieVidDidReq_from_obj({
        SystemId = SystemId,
        IsLocal = IsLocal,
        CpuId = CpuId,
        Bus = Bus,
        Device = Device,
        Function = Function
    })
end
---@param obj Pmu.GetPcieVidDidReq
function TGetPcieVidDidReq:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.IsLocal = obj.IsLocal
    self.CpuId = obj.CpuId
    self.Bus = obj.Bus
    self.Device = obj.Device
    self.Function = obj.Function
end

function TGetPcieVidDidReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPcieVidDidReq.group)
end

TGetPcieVidDidReq.from_obj = TGetPcieVidDidReq_from_obj

TGetPcieVidDidReq.proto_property = {'SystemId', 'IsLocal', 'CpuId', 'Bus', 'Device', 'Function'}

TGetPcieVidDidReq.default = {0, false, 0, 0, 0, 0}

TGetPcieVidDidReq.struct = {
    {name = 'SystemId', is_array = false, struct = nil}, {name = 'IsLocal', is_array = false, struct = nil},
    {name = 'CpuId', is_array = false, struct = nil}, {name = 'Bus', is_array = false, struct = nil},
    {name = 'Device', is_array = false, struct = nil}, {name = 'Function', is_array = false, struct = nil}
}

function TGetPcieVidDidReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemId', self.SystemId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'IsLocal', self.IsLocal, 'bool', false, errs, need_convert)
    validate.Optional(prefix .. 'CpuId', self.CpuId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Bus', self.Bus, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Device', self.Device, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Function', self.Function, 'uint8', false, errs, need_convert)

    TGetPcieVidDidReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPcieVidDidReq.proto_property, errs, need_convert)
    return self
end

function TGetPcieVidDidReq:unpack(_)
    return self.SystemId, self.IsLocal, self.CpuId, self.Bus, self.Device, self.Function
end

Pmu.GetPcieVidDidReq = TGetPcieVidDidReq

---@class Pmu.ResetRsp
---@field Result integer
local TResetRsp = {}
TResetRsp.__index = TResetRsp
TResetRsp.group = {}

local function TResetRsp_from_obj(obj)
    return setmetatable(obj, TResetRsp)
end

function TResetRsp.new(Result)
    return TResetRsp_from_obj({Result = Result})
end
---@param obj Pmu.ResetRsp
function TResetRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TResetRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetRsp.group)
end

TResetRsp.from_obj = TResetRsp_from_obj

TResetRsp.proto_property = {'Result'}

TResetRsp.default = {0}

TResetRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TResetRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'uint8', false, errs, need_convert)

    TResetRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetRsp.proto_property, errs, need_convert)
    return self
end

function TResetRsp:unpack(_)
    return self.Result
end

Pmu.ResetRsp = TResetRsp

---@class Pmu.ResetReq
local TResetReq = {}
TResetReq.__index = TResetReq
TResetReq.group = {}

local function TResetReq_from_obj(obj)
    return setmetatable(obj, TResetReq)
end

function TResetReq.new()
    return TResetReq_from_obj({})
end
---@param obj Pmu.ResetReq
function TResetReq:init_from_obj(obj)

end

function TResetReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetReq.group)
end

TResetReq.from_obj = TResetReq_from_obj

TResetReq.proto_property = {}

TResetReq.default = {}

TResetReq.struct = {}

function TResetReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TResetReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetReq.proto_property, errs, need_convert)
    return self
end

function TResetReq:unpack(_)
end

Pmu.ResetReq = TResetReq

Pmu.interface = mdb.register_interface('bmc.kepler.Systems.Pmu', {
    SystemId = {'y', nil, true, nil, false},
    Status = {'y', nil, true, 0, false},
    PmuType = {'y', nil, true, 0, false},
    PmuVersion = {'s', nil, true, nil, false},
    SFPMaxTemperature = {'q', nil, true, nil, false}
}, {
    Reset = {'a{ss}', 'y', TResetReq, TResetRsp},
    GetPcieVidDid = {'a{ss}ybyyyy', 'qq', TGetPcieVidDidReq, TGetPcieVidDidRsp},
    GetPcieSubVidDid = {'a{ss}ybyyyy', 'qq', TGetPcieSubVidDidReq, TGetPcieSubVidDidRsp}
}, {})

return Pmu
