-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Maintenance = {}

---@class Maintenance.ImportRsp
---@field TaskId integer
local TImportRsp = {}
TImportRsp.__index = TImportRsp
TImportRsp.group = {}

local function TImportRsp_from_obj(obj)
    return setmetatable(obj, TImportRsp)
end

function TImportRsp.new(TaskId)
    return TImportRsp_from_obj({TaskId = TaskId})
end
---@param obj Maintenance.ImportRsp
function TImportRsp:init_from_obj(obj)
    self.TaskId = obj.TaskId
end

function TImportRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TImportRsp.group)
end

TImportRsp.from_obj = TImportRsp_from_obj

TImportRsp.proto_property = {'TaskId'}

TImportRsp.default = {0}

TImportRsp.struct = {{name = 'TaskId', is_array = false, struct = nil}}

function TImportRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TaskId', self.TaskId, 'uint32', false, errs, need_convert)

    TImportRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TImportRsp.proto_property, errs, need_convert)
    return self
end

function TImportRsp:unpack(_)
    return self.TaskId
end

Maintenance.ImportRsp = TImportRsp

---@class Maintenance.ImportReq
---@field ComponentIdentifier string
---@field FilePath string
local TImportReq = {}
TImportReq.__index = TImportReq
TImportReq.group = {}

local function TImportReq_from_obj(obj)
    return setmetatable(obj, TImportReq)
end

function TImportReq.new(ComponentIdentifier, FilePath)
    return TImportReq_from_obj({ComponentIdentifier = ComponentIdentifier, FilePath = FilePath})
end
---@param obj Maintenance.ImportReq
function TImportReq:init_from_obj(obj)
    self.ComponentIdentifier = obj.ComponentIdentifier
    self.FilePath = obj.FilePath
end

function TImportReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TImportReq.group)
end

TImportReq.from_obj = TImportReq_from_obj

TImportReq.proto_property = {'ComponentIdentifier', 'FilePath'}

TImportReq.default = {'', ''}

TImportReq.struct = {
    {name = 'ComponentIdentifier', is_array = false, struct = nil}, {name = 'FilePath', is_array = false, struct = nil}
}

function TImportReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ComponentIdentifier', self.ComponentIdentifier, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'FilePath', self.FilePath, 'string', false, errs, need_convert)

    TImportReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TImportReq.proto_property, errs, need_convert)
    return self
end

function TImportReq:unpack(_)
    return self.ComponentIdentifier, self.FilePath
end

Maintenance.ImportReq = TImportReq

Maintenance.interface = mdb.register_interface('bmc.kepler.UpdateService.Maintenance', {},
    {Import = {'a{ss}ss', 'u', TImportReq, TImportRsp}}, {})

return Maintenance
