-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'
local create_enum_type = require 'mc.enum'

local EyeDiagram = {}

---@class EyeDiagram.ScopeSel: Enum
local EScopeSel = create_enum_type('ScopeSel')
EScopeSel.default = EScopeSel.new(2147483647)
EScopeSel.struct = nil
EScopeSel.BeforeAFESampling = EScopeSel.new(0)
EScopeSel.AfterAFESampling = EScopeSel.new(1)

EyeDiagram.ScopeSel = EScopeSel

---@class EyeDiagram.PortType: Enum
local EPortType = create_enum_type('PortType')
EPortType.default = EPortType.new(2147483647)
EPortType.struct = nil
EPortType.PCIe0 = EPortType.new(0)
EPortType.PCIe1 = EPortType.new(1)
EPortType.GMAC2 = EPortType.new(2)
EPortType.GMAC3 = EPortType.new(3)
EPortType.USB = EPortType.new(4)

EyeDiagram.PortType = EPortType

---@class EyeDiagram.GetResultRsp
---@field Result string
local TGetResultRsp = {}
TGetResultRsp.__index = TGetResultRsp
TGetResultRsp.group = {}

local function TGetResultRsp_from_obj(obj)
    return setmetatable(obj, TGetResultRsp)
end

function TGetResultRsp.new(Result)
    return TGetResultRsp_from_obj({Result = Result})
end
---@param obj EyeDiagram.GetResultRsp
function TGetResultRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TGetResultRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetResultRsp.group)
end

TGetResultRsp.from_obj = TGetResultRsp_from_obj

TGetResultRsp.proto_property = {'Result'}

TGetResultRsp.default = {''}

TGetResultRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TGetResultRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'string', false, errs, need_convert)

    TGetResultRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetResultRsp.proto_property, errs, need_convert)
    return self
end

function TGetResultRsp:unpack(_)
    return self.Result
end

EyeDiagram.GetResultRsp = TGetResultRsp

---@class EyeDiagram.GetResultReq
---@field Row integer
---@field Cols integer
---@field CompareValue integer
local TGetResultReq = {}
TGetResultReq.__index = TGetResultReq
TGetResultReq.group = {}

local function TGetResultReq_from_obj(obj)
    return setmetatable(obj, TGetResultReq)
end

function TGetResultReq.new(Row, Cols, CompareValue)
    return TGetResultReq_from_obj({Row = Row, Cols = Cols, CompareValue = CompareValue})
end
---@param obj EyeDiagram.GetResultReq
function TGetResultReq:init_from_obj(obj)
    self.Row = obj.Row
    self.Cols = obj.Cols
    self.CompareValue = obj.CompareValue
end

function TGetResultReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetResultReq.group)
end

TGetResultReq.from_obj = TGetResultReq_from_obj

TGetResultReq.proto_property = {'Row', 'Cols', 'CompareValue'}

TGetResultReq.default = {0, 0, 0}

TGetResultReq.struct = {
    {name = 'Row', is_array = false, struct = nil}, {name = 'Cols', is_array = false, struct = nil},
    {name = 'CompareValue', is_array = false, struct = nil}
}

function TGetResultReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Row', self.Row, 'int32', false, errs, need_convert)
    validate.Optional(prefix .. 'Cols', self.Cols, 'int32', false, errs, need_convert)
    validate.Optional(prefix .. 'CompareValue', self.CompareValue, 'int32', false, errs, need_convert)

    TGetResultReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetResultReq.proto_property, errs, need_convert)
    return self
end

function TGetResultReq:unpack(_)
    return self.Row, self.Cols, self.CompareValue
end

EyeDiagram.GetResultReq = TGetResultReq

---@class EyeDiagram.StartTestRsp
---@field Row integer
---@field Cols integer
local TStartTestRsp = {}
TStartTestRsp.__index = TStartTestRsp
TStartTestRsp.group = {}

local function TStartTestRsp_from_obj(obj)
    return setmetatable(obj, TStartTestRsp)
end

function TStartTestRsp.new(Row, Cols)
    return TStartTestRsp_from_obj({Row = Row, Cols = Cols})
end
---@param obj EyeDiagram.StartTestRsp
function TStartTestRsp:init_from_obj(obj)
    self.Row = obj.Row
    self.Cols = obj.Cols
end

function TStartTestRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartTestRsp.group)
end

TStartTestRsp.from_obj = TStartTestRsp_from_obj

TStartTestRsp.proto_property = {'Row', 'Cols'}

TStartTestRsp.default = {0, 0}

TStartTestRsp.struct = {{name = 'Row', is_array = false, struct = nil}, {name = 'Cols', is_array = false, struct = nil}}

function TStartTestRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Row', self.Row, 'int32', false, errs, need_convert)
    validate.Optional(prefix .. 'Cols', self.Cols, 'int32', false, errs, need_convert)

    TStartTestRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartTestRsp.proto_property, errs, need_convert)
    return self
end

function TStartTestRsp:unpack(_)
    return self.Row, self.Cols
end

EyeDiagram.StartTestRsp = TStartTestRsp

---@class EyeDiagram.StartTestReq
---@field Type EyeDiagram.PortType
---@field ScopeSel EyeDiagram.ScopeSel
local TStartTestReq = {}
TStartTestReq.__index = TStartTestReq
TStartTestReq.group = {}

local function TStartTestReq_from_obj(obj)
    obj.Type = obj.Type and EyeDiagram.PortType.new(obj.Type)
    obj.ScopeSel = obj.ScopeSel and EyeDiagram.ScopeSel.new(obj.ScopeSel)
    return setmetatable(obj, TStartTestReq)
end

function TStartTestReq.new(Type, ScopeSel)
    return TStartTestReq_from_obj({Type = Type, ScopeSel = ScopeSel})
end
---@param obj EyeDiagram.StartTestReq
function TStartTestReq:init_from_obj(obj)
    self.Type = obj.Type
    self.ScopeSel = obj.ScopeSel
end

function TStartTestReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStartTestReq.group)
end

TStartTestReq.from_obj = TStartTestReq_from_obj

TStartTestReq.proto_property = {'Type', 'ScopeSel'}

TStartTestReq.default = {EyeDiagram.PortType.default, EyeDiagram.ScopeSel.default}

TStartTestReq.struct = {
    {name = 'Type', is_array = false, struct = EyeDiagram.PortType.struct},
    {name = 'ScopeSel', is_array = false, struct = EyeDiagram.ScopeSel.struct}
}

function TStartTestReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Type', self.Type, 'EyeDiagram.PortType', false, errs, need_convert)
    validate.Optional(prefix .. 'ScopeSel', self.ScopeSel, 'EyeDiagram.ScopeSel', false, errs, need_convert)

    TStartTestReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStartTestReq.proto_property, errs, need_convert)
    return self
end

function TStartTestReq:unpack(raw)
    local Type = utils.unpack_enum(raw, self.Type)
    local ScopeSel = utils.unpack_enum(raw, self.ScopeSel)
    return Type, ScopeSel
end

EyeDiagram.StartTestReq = TStartTestReq

EyeDiagram.interface = mdb.register_interface('bmc.kepler.Managers.SOC.Serdes.EyeDiagram', {}, {
    StartTest = {'a{ss}ii', 'ii', TStartTestReq, TStartTestRsp},
    GetResult = {'a{ss}iii', 's', TGetResultReq, TGetResultRsp}
}, {})

return EyeDiagram
