--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetHttpsEnable = {}

---@class GeneralHardwareIpmiCmds.SetHttpsEnableReq
---@field ManufactureId integer
---@field Rsvd integer
---@field DeviceNo integer
---@field Offset integer
---@field PxeOption integer
local TSetHttpsEnableReq = {}
TSetHttpsEnableReq.__index = TSetHttpsEnableReq
TSetHttpsEnableReq.group = {}

local function TSetHttpsEnableReq_from_obj(obj)
    return setmetatable(obj, TSetHttpsEnableReq)
end

function TSetHttpsEnableReq.new(ManufactureId, Rsvd, DeviceNo, Offset, PxeOption)
    return TSetHttpsEnableReq_from_obj({
        ManufactureId = ManufactureId,
        Rsvd = Rsvd,
        DeviceNo = DeviceNo,
        Offset = Offset,
        PxeOption = PxeOption
    })
end
---@param obj GeneralHardwareIpmiCmds.SetHttpsEnableReq
function TSetHttpsEnableReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Rsvd = obj.Rsvd
    self.DeviceNo = obj.DeviceNo
    self.Offset = obj.Offset
    self.PxeOption = obj.PxeOption
end

function TSetHttpsEnableReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetHttpsEnableReq.group)
end

TSetHttpsEnableReq.from_obj = TSetHttpsEnableReq_from_obj

TSetHttpsEnableReq.proto_property = {'ManufactureId', 'Rsvd', 'DeviceNo', 'Offset', 'PxeOption'}

TSetHttpsEnableReq.default = {0, 0, 0, 0, 0}

TSetHttpsEnableReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'Rsvd', is_array = false, struct = nil},
    {name = 'DeviceNo', is_array = false, struct = nil}, {name = 'Offset', is_array = false, struct = nil},
    {name = 'PxeOption', is_array = false, struct = nil}
}

function TSetHttpsEnableReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Rsvd', self.Rsvd, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceNo', self.DeviceNo, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'PxeOption', self.PxeOption, 'uint8', false, errs, need_convert)

    TSetHttpsEnableReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetHttpsEnableReq.proto_property, errs, need_convert)
    return self
end

function TSetHttpsEnableReq:unpack(_)
    return self.ManufactureId, self.Rsvd, self.DeviceNo, self.Offset, self.PxeOption
end

SetHttpsEnable.SetHttpsEnableReq = TSetHttpsEnableReq

---@class GeneralHardwareIpmiCmds.SetHttpsEnableRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetHttpsEnableRsp = {}
TSetHttpsEnableRsp.__index = TSetHttpsEnableRsp
TSetHttpsEnableRsp.group = {}

local function TSetHttpsEnableRsp_from_obj(obj)
    return setmetatable(obj, TSetHttpsEnableRsp)
end

function TSetHttpsEnableRsp.new(CompletionCode, ManufactureId)
    return TSetHttpsEnableRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj GeneralHardwareIpmiCmds.SetHttpsEnableRsp
function TSetHttpsEnableRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetHttpsEnableRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetHttpsEnableRsp.group)
end

TSetHttpsEnableRsp.from_obj = TSetHttpsEnableRsp_from_obj

TSetHttpsEnableRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetHttpsEnableRsp.default = {0, 0}

TSetHttpsEnableRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetHttpsEnableRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetHttpsEnableRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetHttpsEnableRsp.proto_property, errs, need_convert)
    return self
end

function TSetHttpsEnableRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetHttpsEnable.SetHttpsEnableRsp = TSetHttpsEnableRsp

return SetHttpsEnable
