--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetDpuSolSwitch = {}

---@class GeneralHardwareIpmiCmds.SetDpuSolSwitchReq
---@field ManufactureId integer
---@field Reserved integer
---@field DeviceNo integer
---@field Offset integer
---@field Uart integer
local TSetDpuSolSwitchReq = {}
TSetDpuSolSwitchReq.__index = TSetDpuSolSwitchReq
TSetDpuSolSwitchReq.group = {}

local function TSetDpuSolSwitchReq_from_obj(obj)
    return setmetatable(obj, TSetDpuSolSwitchReq)
end

function TSetDpuSolSwitchReq.new(ManufactureId, Reserved, DeviceNo, Offset, Uart)
    return TSetDpuSolSwitchReq_from_obj({
        ManufactureId = ManufactureId,
        Reserved = Reserved,
        DeviceNo = DeviceNo,
        Offset = Offset,
        Uart = Uart
    })
end
---@param obj GeneralHardwareIpmiCmds.SetDpuSolSwitchReq
function TSetDpuSolSwitchReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Reserved = obj.Reserved
    self.DeviceNo = obj.DeviceNo
    self.Offset = obj.Offset
    self.Uart = obj.Uart
end

function TSetDpuSolSwitchReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDpuSolSwitchReq.group)
end

TSetDpuSolSwitchReq.from_obj = TSetDpuSolSwitchReq_from_obj

TSetDpuSolSwitchReq.proto_property = {'ManufactureId', 'Reserved', 'DeviceNo', 'Offset', 'Uart'}

TSetDpuSolSwitchReq.default = {0, 0, 0, 0, 0}

TSetDpuSolSwitchReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'Reserved', is_array = false, struct = nil},
    {name = 'DeviceNo', is_array = false, struct = nil}, {name = 'Offset', is_array = false, struct = nil},
    {name = 'Uart', is_array = false, struct = nil}
}

function TSetDpuSolSwitchReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceNo', self.DeviceNo, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'Uart', self.Uart, 'uint8', false, errs, need_convert)

    TSetDpuSolSwitchReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDpuSolSwitchReq.proto_property, errs, need_convert)
    return self
end

function TSetDpuSolSwitchReq:unpack(_)
    return self.ManufactureId, self.Reserved, self.DeviceNo, self.Offset, self.Uart
end

SetDpuSolSwitch.SetDpuSolSwitchReq = TSetDpuSolSwitchReq

---@class GeneralHardwareIpmiCmds.SetDpuSolSwitchRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetDpuSolSwitchRsp = {}
TSetDpuSolSwitchRsp.__index = TSetDpuSolSwitchRsp
TSetDpuSolSwitchRsp.group = {}

local function TSetDpuSolSwitchRsp_from_obj(obj)
    return setmetatable(obj, TSetDpuSolSwitchRsp)
end

function TSetDpuSolSwitchRsp.new(CompletionCode, ManufactureId)
    return TSetDpuSolSwitchRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj GeneralHardwareIpmiCmds.SetDpuSolSwitchRsp
function TSetDpuSolSwitchRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetDpuSolSwitchRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDpuSolSwitchRsp.group)
end

TSetDpuSolSwitchRsp.from_obj = TSetDpuSolSwitchRsp_from_obj

TSetDpuSolSwitchRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetDpuSolSwitchRsp.default = {0, 0}

TSetDpuSolSwitchRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetDpuSolSwitchRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetDpuSolSwitchRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDpuSolSwitchRsp.proto_property, errs, need_convert)
    return self
end

function TSetDpuSolSwitchRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetDpuSolSwitch.SetDpuSolSwitchRsp = TSetDpuSolSwitchRsp

return SetDpuSolSwitch
