--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetDpuPowerState = {}

---@class GeneralHardwareIpmiCmds.SetDpuPowerStateReq
---@field ManufactureId integer
---@field Reserved integer
---@field DeviceNo integer
---@field Offset integer
---@field PowerState integer
local TSetDpuPowerStateReq = {}
TSetDpuPowerStateReq.__index = TSetDpuPowerStateReq
TSetDpuPowerStateReq.group = {}

local function TSetDpuPowerStateReq_from_obj(obj)
    return setmetatable(obj, TSetDpuPowerStateReq)
end

function TSetDpuPowerStateReq.new(ManufactureId, Reserved, DeviceNo, Offset, PowerState)
    return TSetDpuPowerStateReq_from_obj({
        ManufactureId = ManufactureId,
        Reserved = Reserved,
        DeviceNo = DeviceNo,
        Offset = Offset,
        PowerState = PowerState
    })
end
---@param obj GeneralHardwareIpmiCmds.SetDpuPowerStateReq
function TSetDpuPowerStateReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Reserved = obj.Reserved
    self.DeviceNo = obj.DeviceNo
    self.Offset = obj.Offset
    self.PowerState = obj.PowerState
end

function TSetDpuPowerStateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDpuPowerStateReq.group)
end

TSetDpuPowerStateReq.from_obj = TSetDpuPowerStateReq_from_obj

TSetDpuPowerStateReq.proto_property = {'ManufactureId', 'Reserved', 'DeviceNo', 'Offset', 'PowerState'}

TSetDpuPowerStateReq.default = {0, 0, 0, 0, 0}

TSetDpuPowerStateReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'Reserved', is_array = false, struct = nil},
    {name = 'DeviceNo', is_array = false, struct = nil}, {name = 'Offset', is_array = false, struct = nil},
    {name = 'PowerState', is_array = false, struct = nil}
}

function TSetDpuPowerStateReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceNo', self.DeviceNo, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'PowerState', self.PowerState, 'uint8', false, errs, need_convert)

    TSetDpuPowerStateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDpuPowerStateReq.proto_property, errs, need_convert)
    return self
end

function TSetDpuPowerStateReq:unpack(_)
    return self.ManufactureId, self.Reserved, self.DeviceNo, self.Offset, self.PowerState
end

SetDpuPowerState.SetDpuPowerStateReq = TSetDpuPowerStateReq

---@class GeneralHardwareIpmiCmds.SetDpuPowerStateRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetDpuPowerStateRsp = {}
TSetDpuPowerStateRsp.__index = TSetDpuPowerStateRsp
TSetDpuPowerStateRsp.group = {}

local function TSetDpuPowerStateRsp_from_obj(obj)
    return setmetatable(obj, TSetDpuPowerStateRsp)
end

function TSetDpuPowerStateRsp.new(CompletionCode, ManufactureId)
    return TSetDpuPowerStateRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj GeneralHardwareIpmiCmds.SetDpuPowerStateRsp
function TSetDpuPowerStateRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetDpuPowerStateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDpuPowerStateRsp.group)
end

TSetDpuPowerStateRsp.from_obj = TSetDpuPowerStateRsp_from_obj

TSetDpuPowerStateRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetDpuPowerStateRsp.default = {0, 0}

TSetDpuPowerStateRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetDpuPowerStateRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetDpuPowerStateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDpuPowerStateRsp.proto_property, errs, need_convert)
    return self
end

function TSetDpuPowerStateRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetDpuPowerState.SetDpuPowerStateRsp = TSetDpuPowerStateRsp

return SetDpuPowerState
