--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetDpuIp = {}

---@class GeneralHardwareIpmiCmds.SetDpuIpReq
---@field ManufactureId integer
---@field Reserved integer
---@field DeviceNo integer
---@field Offset integer
---@field Ipv4 integer
---@field Mask integer
---@field Vlan integer
local TSetDpuIpReq = {}
TSetDpuIpReq.__index = TSetDpuIpReq
TSetDpuIpReq.group = {}

local function TSetDpuIpReq_from_obj(obj)
    return setmetatable(obj, TSetDpuIpReq)
end

function TSetDpuIpReq.new(ManufactureId, Reserved, DeviceNo, Offset, Ipv4, Mask, Vlan)
    return TSetDpuIpReq_from_obj({
        ManufactureId = ManufactureId,
        Reserved = Reserved,
        DeviceNo = DeviceNo,
        Offset = Offset,
        Ipv4 = Ipv4,
        Mask = Mask,
        Vlan = Vlan
    })
end
---@param obj GeneralHardwareIpmiCmds.SetDpuIpReq
function TSetDpuIpReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Reserved = obj.Reserved
    self.DeviceNo = obj.DeviceNo
    self.Offset = obj.Offset
    self.Ipv4 = obj.Ipv4
    self.Mask = obj.Mask
    self.Vlan = obj.Vlan
end

function TSetDpuIpReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDpuIpReq.group)
end

TSetDpuIpReq.from_obj = TSetDpuIpReq_from_obj

TSetDpuIpReq.proto_property = {'ManufactureId', 'Reserved', 'DeviceNo', 'Offset', 'Ipv4', 'Mask', 'Vlan'}

TSetDpuIpReq.default = {0, 0, 0, 0, 0, 0, 0}

TSetDpuIpReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'Reserved', is_array = false, struct = nil},
    {name = 'DeviceNo', is_array = false, struct = nil}, {name = 'Offset', is_array = false, struct = nil},
    {name = 'Ipv4', is_array = false, struct = nil}, {name = 'Mask', is_array = false, struct = nil},
    {name = 'Vlan', is_array = false, struct = nil}
}

function TSetDpuIpReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Reserved', self.Reserved, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceNo', self.DeviceNo, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint16', false, errs, need_convert)
    validate.Optional(prefix .. 'Ipv4', self.Ipv4, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Mask', self.Mask, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Vlan', self.Vlan, 'uint16', false, errs, need_convert)

    TSetDpuIpReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDpuIpReq.proto_property, errs, need_convert)
    return self
end

function TSetDpuIpReq:unpack(_)
    return self.ManufactureId, self.Reserved, self.DeviceNo, self.Offset, self.Ipv4, self.Mask, self.Vlan
end

SetDpuIp.SetDpuIpReq = TSetDpuIpReq

---@class GeneralHardwareIpmiCmds.SetDpuIpRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetDpuIpRsp = {}
TSetDpuIpRsp.__index = TSetDpuIpRsp
TSetDpuIpRsp.group = {}

local function TSetDpuIpRsp_from_obj(obj)
    return setmetatable(obj, TSetDpuIpRsp)
end

function TSetDpuIpRsp.new(CompletionCode, ManufactureId)
    return TSetDpuIpRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj GeneralHardwareIpmiCmds.SetDpuIpRsp
function TSetDpuIpRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetDpuIpRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDpuIpRsp.group)
end

TSetDpuIpRsp.from_obj = TSetDpuIpRsp_from_obj

TSetDpuIpRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetDpuIpRsp.default = {0, 0}

TSetDpuIpRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetDpuIpRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetDpuIpRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDpuIpRsp.proto_property, errs, need_convert)
    return self
end

function TSetDpuIpRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetDpuIp.SetDpuIpRsp = TSetDpuIpRsp

return SetDpuIp
